
#include <stdint.h>

// GF2^9
const uint16_t gf2_13_expTab[8191] = {
    1,    2,    4,    8,    16,   32,   64,   128,  256,  512,  1024, 2048, 4096, 27,   54,   108,  216,  432,  864,
    1728, 3456, 6912, 5659, 3117, 6234, 4271, 325,  650,  1300, 2600, 5200, 2235, 4470, 759,  1518, 3036, 6072, 3947,
    7894, 7607, 7029, 5873, 3577, 7154, 6143, 4069, 8138, 8079, 7941, 7697, 7225, 6249, 4297, 393,  786,  1572, 3144,
    6288, 4411, 621,  1242, 2484, 4968, 1739, 3478, 6956, 5699, 3229, 6458, 4719, 1221, 2442, 4884, 1587, 3174, 6348,
    4483, 797,  1594, 3188, 6376, 4555, 909,  1818, 3636, 7272, 6347, 4493, 769,  1538, 3076, 6152, 4107, 13,   26,
    52,   104,  208,  416,  832,  1664, 3328, 6656, 5147, 2093, 4186, 175,  350,  700,  1400, 2800, 5600, 3035, 6070,
    3959, 7918, 7623, 7061, 5937, 3705, 7410, 6655, 5093, 2001, 4002, 8004, 7827, 7485, 6753, 5337, 2473, 4946, 1727,
    3454, 6908, 5603, 3037, 6074, 3951, 7902, 7591, 6997, 5809, 3449, 6898, 5631, 3045, 6090, 3983, 7966, 7719, 7253,
    6321, 4473, 745,  1490, 2980, 5960, 3723, 7446, 6711, 5237, 2289, 4578, 991,  1982, 3964, 7928, 7659, 7117, 6017,
    3865, 7730, 7295, 6373, 4561, 953,  1906, 3812, 7624, 7051, 5901, 3585, 7170, 6175, 4133, 81,   162,  324,  648,
    1296, 2592, 5184, 2203, 4406, 631,  1262, 2524, 5048, 1899, 3798, 7596, 6979, 5789, 3361, 6722, 5279, 2341, 4682,
    1167, 2334, 4668, 1123, 2246, 4492, 771,  1542, 3084, 6168, 4139, 77,   154,  308,  616,  1232, 2464, 4928, 1691,
    3382, 6764, 5315, 2461, 4922, 1647, 3294, 6588, 4963, 1757, 3514, 7028, 5875, 3581, 7162, 6127, 4037, 8074, 7951,
    7685, 7185, 6201, 4201, 201,  402,  804,  1608, 3216, 6432, 4699, 1197, 2394, 4788, 1395, 2790, 5580, 2947, 5894,
    3607, 7214, 6215, 4245, 305,  610,  1220, 2440, 4880, 1595, 3190, 6380, 4547, 925,  1850, 3700, 7400, 6603, 5005,
    1793, 3586, 7172, 6163, 4157, 97,   194,  388,  776,  1552, 3104, 6208, 4251, 301,  602,  1204, 2408, 4816, 1467,
    2934, 5868, 3523, 7046, 5911, 3637, 7274, 6351, 4485, 785,  1570, 3140, 6280, 4363, 525,  1050, 2100, 4200, 203,
    406,  812,  1624, 3248, 6496, 4827, 1453, 2906, 5812, 3443, 6886, 5591, 2997, 5994, 3791, 7582, 6951, 5717, 3249,
    6498, 4831, 1445, 2890, 5780, 3379, 6758, 5335, 2485, 4970, 1743, 3486, 6972, 5731, 3293, 6586, 4975, 1733, 3466,
    6932, 5683, 3197, 6394, 4591, 965,  1930, 3860, 7720, 7243, 6285, 4353, 537,  1074, 2148, 4296, 395,  790,  1580,
    3160, 6320, 4475, 749,  1498, 2996, 5992, 3787, 7574, 6967, 5749, 3313, 6626, 5087, 1957, 3914, 7828, 7475, 6781,
    5345, 2521, 5042, 1919, 3838, 7676, 7139, 6109, 4001, 8002, 7839, 7461, 6737, 5305, 2409, 4818, 1471, 2942, 5884,
    3555, 7110, 6039, 3893, 7786, 7375, 6533, 4881, 1593, 3186, 6372, 4563, 957,  1914, 3828, 7656, 7115, 6029, 3841,
    7682, 7199, 6181, 4177, 185,  370,  740,  1480, 2960, 5920, 3675, 7350, 6519, 4853, 1521, 3042, 6084, 3987, 7974,
    7767, 7349, 6513, 4857, 1513, 3026, 6052, 3923, 7846, 7511, 6837, 5489, 2809, 5618, 3071, 6142, 4071, 8142, 8071,
    7957, 7729, 7289, 6377, 4553, 905,  1810, 3620, 7240, 6283, 4365, 513,  1026, 2052, 4104, 11,   22,   44,   88,
    176,  352,  704,  1408, 2816, 5632, 3099, 6198, 4215, 245,  490,  980,  1960, 3920, 7840, 7515, 6829, 5441, 2713,
    5426, 2687, 5374, 2535, 5070, 1927, 3854, 7708, 7203, 6237, 4257, 345,  690,  1380, 2760, 5520, 2875, 5750, 3319,
    6638, 5063, 1941, 3882, 7764, 7347, 6525, 4833, 1497, 2994, 5988, 3795, 7590, 6999, 5813, 3441, 6882, 5599, 2981,
    5962, 3727, 7454, 6695, 5205, 2225, 4450, 735,  1470, 2940, 5880, 3563, 7126, 6071, 3957, 7914, 7631, 7045, 5905,
    3641, 7282, 6399, 4581, 977,  1954, 3908, 7816, 7435, 6669, 5121, 2073, 4146, 127,  254,  508,  1016, 2032, 4064,
    8128, 8091, 7981, 7745, 7321, 6441, 4681, 1161, 2322, 4644, 1107, 2214, 4428, 643,  1286, 2572, 5144, 2091, 4182,
    183,  366,  732,  1464, 2928, 5856, 3547, 7094, 6007, 3829, 7658, 7119, 6021, 3857, 7714, 7263, 6309, 4433, 697,
    1394, 2788, 5576, 2955, 5910, 3639, 7278, 6343, 4501, 817,  1634, 3268, 6536, 4875, 1549, 3098, 6196, 4211, 253,
    506,  1012, 2024, 4048, 8096, 8027, 7853, 7489, 6809, 5417, 2633, 5266, 2367, 4734, 1255, 2510, 5020, 1827, 3654,
    7308, 6403, 4637, 1057, 2114, 4228, 275,  550,  1100, 2200, 4400, 635,  1270, 2540, 5080, 1963, 3926, 7852, 7491,
    6813, 5409, 2649, 5298, 2431, 4862, 1511, 3022, 6044, 3875, 7750, 7319, 6453, 4721, 1273, 2546, 5092, 2003, 4006,
    8012, 7811, 7453, 6689, 5209, 2217, 4434, 703,  1406, 2812, 5624, 3051, 6102, 4023, 8046, 7879, 7573, 6961, 5753,
    3305, 6610, 5055, 1893, 3786, 7572, 6963, 5757, 3297, 6594, 5023, 1829, 3658, 7316, 6451, 4733, 1249, 2498, 4996,
    1811, 3622, 7244, 6275, 4381, 545,  1090, 2180, 4360, 523,  1046, 2092, 4184, 171,  342,  684,  1368, 2736, 5472,
    2779, 5558, 2935, 5870, 3527, 7054, 5895, 3605, 7210, 6223, 4229, 273,  546,  1092, 2184, 4368, 571,  1142, 2284,
    4568, 939,  1878, 3756, 7512, 6827, 5453, 2689, 5378, 2591, 5182, 2151, 4302, 391,  782,  1564, 3128, 6256, 4347,
    493,  986,  1972, 3944, 7888, 7611, 7021, 5825, 3481, 6962, 5759, 3301, 6602, 5007, 1797, 3594, 7188, 6195, 4221,
    225,  450,  900,  1800, 3600, 7200, 6235, 4269, 321,  642,  1284, 2568, 5136, 2107, 4214, 247,  494,  988,  1976,
    3952, 7904, 7643, 7085, 5953, 3737, 7474, 6783, 5349, 2513, 5026, 1887, 3774, 7548, 6883, 5597, 2977, 5954, 3743,
    7486, 6759, 5333, 2481, 4962, 1759, 3518, 7036, 5859, 3549, 7098, 5999, 3781, 7562, 6927, 5637, 3089, 6178, 4191,
    165,  330,  660,  1320, 2640, 5280, 2395, 4790, 1399, 2798, 5596, 2979, 5958, 3735, 7470, 6727, 5269, 2353, 4706,
    1247, 2494, 4988, 1763, 3526, 7052, 5891, 3613, 7226, 6255, 4293, 401,  802,  1604, 3208, 6416, 4667, 1133, 2266,
    4532, 883,  1766, 3532, 7064, 5931, 3661, 7322, 6447, 4677, 1169, 2338, 4676, 1171, 2342, 4684, 1155, 2310, 4620,
    1027, 2054, 4108, 3,    6,    12,   24,   48,   96,   192,  384,  768,  1536, 3072, 6144, 4123, 45,   90,   180,
    360,  720,  1440, 2880, 5760, 3355, 6710, 5239, 2293, 4586, 975,  1950, 3900, 7800, 7403, 6605, 4993, 1817, 3634,
    7268, 6355, 4541, 865,  1730, 3460, 6920, 5643, 3085, 6170, 4143, 69,   138,  276,  552,  1104, 2208, 4416, 667,
    1334, 2668, 5336, 2475, 4950, 1719, 3438, 6876, 5539, 2909, 5818, 3439, 6878, 5543, 2901, 5802, 3407, 6814, 5415,
    2645, 5290, 2383, 4766, 1319, 2638, 5276, 2339, 4678, 1175, 2350, 4700, 1187, 2374, 4748, 1283, 2566, 5132, 2051,
    4102, 23,   46,   92,   184,  368,  736,  1472, 2944, 5888, 3611, 7222, 6263, 4341, 497,  994,  1988, 3976, 7952,
    7739, 7277, 6337, 4505, 809,  1618, 3236, 6472, 4747, 1293, 2586, 5172, 2163, 4326, 471,  942,  1884, 3768, 7536,
    6907, 5613, 3009, 6018, 3871, 7742, 7271, 6357, 4529, 889,  1778, 3556, 7112, 6027, 3853, 7706, 7215, 6213, 4241,
    313,  626,  1252, 2504, 5008, 1851, 3702, 7404, 6595, 5021, 1825, 3650, 7300, 6419, 4669, 1121, 2242, 4484, 787,
    1574, 3148, 6296, 4395, 589,  1178, 2356, 4712, 1227, 2454, 4908, 1603, 3206, 6412, 4611, 1053, 2106, 4212, 243,
    486,  972,  1944, 3888, 7776, 7387, 6573, 4929, 1689, 3378, 6756, 5331, 2493, 4986, 1775, 3550, 7100, 5987, 3805,
    7610, 7023, 5829, 3473, 6946, 5727, 3237, 6474, 4751, 1285, 2570, 5140, 2099, 4198, 215,  430,  860,  1720, 3440,
    6880, 5595, 2989, 5978, 3759, 7518, 6823, 5461, 2737, 5474, 2783, 5566, 2919, 5838, 3463, 6926, 5639, 3093, 6186,
    4175, 133,  266,  532,  1064, 2128, 4256, 347,  694,  1388, 2776, 5552, 2939, 5878, 3575, 7150, 6087, 3989, 7978,
    7759, 7301, 6417, 4665, 1129, 2258, 4516, 851,  1702, 3404, 6808, 5419, 2637, 5274, 2351, 4702, 1191, 2382, 4764,
    1315, 2630, 5260, 2307, 4614, 1047, 2094, 4188, 163,  326,  652,  1304, 2608, 5216, 2267, 4534, 887,  1774, 3548,
    7096, 5995, 3789, 7578, 6959, 5701, 3217, 6434, 4703, 1189, 2378, 4756, 1331, 2662, 5324, 2435, 4870, 1559, 3118,
    6236, 4259, 349,  698,  1396, 2792, 5584, 3003, 6006, 3831, 7662, 7111, 6037, 3889, 7778, 7391, 6565, 4945, 1721,
    3442, 6884, 5587, 3005, 6010, 3823, 7646, 7079, 5973, 3761, 7522, 6879, 5541, 2897, 5794, 3423, 6846, 5479, 2773,
    5546, 2895, 5790, 3367, 6734, 5255, 2325, 4650, 1103, 2206, 4412, 611,  1222, 2444, 4888, 1579, 3158, 6316, 4419,
    669,  1338, 2676, 5352, 2507, 5014, 1847, 3694, 7388, 6563, 4957, 1697, 3394, 6788, 5395, 2621, 5242, 2287, 4574,
    935,  1870, 3740, 7480, 6763, 5325, 2433, 4866, 1567, 3134, 6268, 4323, 477,  954,  1908, 3816, 7632, 7099, 5997,
    3777, 7554, 6943, 5669, 3153, 6306, 4447, 677,  1354, 2708, 5416, 2635, 5270, 2359, 4718, 1223, 2446, 4892, 1571,
    3142, 6284, 4355, 541,  1082, 2164, 4328, 459,  918,  1836, 3672, 7344, 6523, 4845, 1473, 2946, 5892, 3603, 7206,
    6231, 4277, 369,  738,  1476, 2952, 5904, 3643, 7286, 6391, 4597, 1009, 2018, 4036, 8072, 7947, 7693, 7169, 6169,
    4137, 73,   146,  292,  584,  1168, 2336, 4672, 1179, 2358, 4716, 1219, 2438, 4876, 1539, 3078, 6156, 4099, 29,
    58,   116,  232,  464,  928,  1856, 3712, 7424, 6683, 5165, 2113, 4226, 287,  574,  1148, 2296, 4592, 1019, 2038,
    4076, 8152, 8107, 8013, 7809, 7449, 6697, 5193, 2185, 4370, 575,  1150, 2300, 4600, 1003, 2006, 4012, 8024, 7851,
    7501, 6785, 5401, 2601, 5202, 2239, 4478, 743,  1486, 2972, 5944, 3691, 7382, 6583, 4981, 1777, 3554, 7108, 6035,
    3901, 7802, 7407, 6597, 5009, 1849, 3698, 7396, 6611, 5053, 1889, 3778, 7556, 6931, 5693, 3169, 6338, 4511, 805,
    1610, 3220, 6440, 4683, 1165, 2330, 4660, 1139, 2278, 4556, 899,  1798, 3596, 7192, 6187, 4173, 129,  258,  516,
    1032, 2064, 4128, 91,   182,  364,  728,  1456, 2912, 5824, 3483, 6966, 5751, 3317, 6634, 5071, 1925, 3850, 7700,
    7219, 6269, 4321, 473,  946,  1892, 3784, 7568, 6971, 5741, 3265, 6530, 4895, 1573, 3146, 6292, 4403, 637,  1274,
    2548, 5096, 1995, 3990, 7980, 7747, 7325, 6433, 4697, 1193, 2386, 4772, 1363, 2726, 5452, 2691, 5382, 2583, 5166,
    2119, 4238, 263,  526,  1052, 2104, 4208, 251,  502,  1004, 2008, 4016, 8032, 7899, 7597, 6977, 5785, 3369, 6738,
    5311, 2405, 4810, 1423, 2846, 5692, 3171, 6342, 4503, 821,  1642, 3284, 6568, 4939, 1677, 3354, 6708, 5235, 2301,
    4602, 1007, 2014, 4028, 8056, 7915, 7629, 7041, 5913, 3625, 7250, 6335, 4453, 721,  1442, 2884, 5768, 3339, 6678,
    5175, 2165, 4330, 463,  926,  1852, 3704, 7408, 6651, 5101, 1985, 3970, 7940, 7699, 7229, 6241, 4313, 425,  850,
    1700, 3400, 6800, 5435, 2669, 5338, 2479, 4958, 1703, 3406, 6812, 5411, 2653, 5306, 2415, 4830, 1447, 2894, 5788,
    3363, 6726, 5271, 2357, 4714, 1231, 2462, 4924, 1635, 3270, 6540, 4867, 1565, 3130, 6260, 4339, 509,  1018, 2036,
    4072, 8144, 8123, 8045, 7873, 7577, 6953, 5705, 3209, 6418, 4671, 1125, 2250, 4500, 819,  1638, 3276, 6552, 4907,
    1613, 3226, 6452, 4723, 1277, 2554, 5108, 2035, 4070, 8140, 8067, 7965, 7713, 7257, 6313, 4425, 649,  1298, 2596,
    5192, 2187, 4374, 567,  1134, 2268, 4536, 875,  1750, 3500, 7000, 5803, 3405, 6810, 5423, 2629, 5258, 2319, 4638,
    1063, 2126, 4252, 291,  582,  1164, 2328, 4656, 1147, 2294, 4588, 963,  1926, 3852, 7704, 7211, 6221, 4225, 281,
    562,  1124, 2248, 4496, 827,  1654, 3308, 6616, 5035, 1869, 3738, 7476, 6771, 5373, 2529, 5058, 1951, 3902, 7804,
    7395, 6621, 5025, 1881, 3762, 7524, 6867, 5565, 2913, 5826, 3487, 6974, 5735, 3285, 6570, 4943, 1669, 3338, 6676,
    5171, 2173, 4346, 495,  990,  1980, 3960, 7920, 7675, 7149, 6081, 3993, 7986, 7807, 7397, 6609, 5049, 1897, 3794,
    7588, 6995, 5821, 3425, 6850, 5535, 2853, 5706, 3215, 6430, 4647, 1109, 2218, 4436, 691,  1382, 2764, 5528, 2859,
    5718, 3255, 6510, 4807, 1429, 2858, 5716, 3251, 6502, 4823, 1461, 2922, 5844, 3507, 7014, 5847, 3509, 7018, 5839,
    3461, 6922, 5647, 3077, 6154, 4111, 5,    10,   20,   40,   80,   160,  320,  640,  1280, 2560, 5120, 2075, 4150,
    119,  238,  476,  952,  1904, 3808, 7616, 7067, 5933, 3649, 7298, 6431, 4645, 1105, 2210, 4420, 659,  1318, 2636,
    5272, 2347, 4694, 1207, 2414, 4828, 1443, 2886, 5772, 3331, 6662, 5143, 2101, 4202, 207,  414,  828,  1656, 3312,
    6624, 5083, 1965, 3930, 7860, 7539, 6909, 5601, 3033, 6066, 3967, 7934, 7655, 7125, 6065, 3961, 7922, 7679, 7141,
    6097, 4025, 8050, 7935, 7653, 7121, 6073, 3945, 7890, 7615, 7013, 5841, 3513, 7026, 5887, 3557, 7114, 6031, 3845,
    7690, 7183, 6149, 4113, 57,   114,  228,  456,  912,  1824, 3648, 7296, 6427, 4653, 1089, 2178, 4356, 531,  1062,
    2124, 4248, 299,  598,  1196, 2392, 4784, 1403, 2806, 5612, 3011, 6022, 3863, 7726, 7239, 6293, 4401, 633,  1266,
    2532, 5064, 1931, 3862, 7724, 7235, 6301, 4385, 601,  1202, 2404, 4808, 1419, 2838, 5676, 3139, 6278, 4375, 565,
    1130, 2260, 4520, 843,  1686, 3372, 6744, 5291, 2381, 4762, 1327, 2654, 5308, 2403, 4806, 1431, 2862, 5724, 3235,
    6470, 4759, 1333, 2666, 5332, 2483, 4966, 1751, 3502, 7004, 5795, 3421, 6842, 5487, 2757, 5514, 2831, 5662, 3111,
    6222, 4231, 277,  554,  1108, 2216, 4432, 699,  1398, 2796, 5592, 2987, 5974, 3767, 7534, 6855, 5525, 2865, 5730,
    3295, 6590, 4967, 1749, 3498, 6996, 5811, 3453, 6906, 5615, 3013, 6026, 3855, 7710, 7207, 6229, 4273, 377,  754,
    1508, 3016, 6032, 3899, 7798, 7415, 6645, 5105, 2041, 4082, 8164, 8147, 8125, 8033, 7897, 7593, 6985, 5769, 3337,
    6674, 5183, 2149, 4298, 399,  798,  1596, 3192, 6384, 4603, 1005, 2010, 4020, 8040, 7883, 7565, 6913, 5657, 3113,
    6226, 4287, 357,  714,  1428, 2856, 5712, 3259, 6518, 4855, 1525, 3050, 6100, 4019, 8038, 7895, 7605, 7025, 5881,
    3561, 7122, 6079, 3941, 7882, 7567, 6917, 5649, 3129, 6258, 4351, 485,  970,  1940, 3880, 7760, 7355, 6509, 4801,
    1433, 2866, 5732, 3283, 6566, 4951, 1717, 3434, 6868, 5555, 2941, 5882, 3567, 7134, 6055, 3925, 7850, 7503, 6789,
    5393, 2617, 5234, 2303, 4606, 999,  1998, 3996, 7992, 7787, 7373, 6529, 4889, 1577, 3154, 6308, 4435, 701,  1402,
    2804, 5608, 3019, 6038, 3895, 7790, 7367, 6549, 4913, 1657, 3314, 6628, 5075, 1981, 3962, 7924, 7667, 7165, 6113,
    4057, 8114, 8063, 7909, 7633, 7097, 5993, 3785, 7570, 6975, 5733, 3281, 6562, 4959, 1701, 3402, 6804, 5427, 2685,
    5370, 2543, 5086, 1959, 3918, 7836, 7459, 6749, 5281, 2393, 4786, 1407, 2814, 5628, 3043, 6086, 3991, 7982, 7751,
    7317, 6449, 4729, 1257, 2514, 5028, 1875, 3750, 7500, 6787, 5405, 2593, 5186, 2207, 4414, 615,  1230, 2460, 4920,
    1643, 3286, 6572, 4931, 1693, 3386, 6772, 5363, 2557, 5114, 2031, 4062, 8124, 8035, 7901, 7585, 7001, 5801, 3401,
    6802, 5439, 2661, 5322, 2447, 4894, 1575, 3150, 6300, 4387, 605,  1210, 2420, 4840, 1483, 2966, 5932, 3651, 7302,
    6423, 4661, 1137, 2274, 4548, 915,  1830, 3660, 7320, 6443, 4685, 1153, 2306, 4612, 1043, 2086, 4172, 131,  262,
    524,  1048, 2096, 4192, 219,  438,  876,  1752, 3504, 7008, 5851, 3501, 7002, 5807, 3397, 6794, 5391, 2565, 5130,
    2063, 4126, 39,   78,   156,  312,  624,  1248, 2496, 4992, 1819, 3638, 7276, 6339, 4509, 801,  1602, 3204, 6408,
    4619, 1037, 2074, 4148, 115,  230,  460,  920,  1840, 3680, 7360, 6555, 4909, 1601, 3202, 6404, 4627, 1085, 2170,
    4340, 499,  998,  1996, 3992, 7984, 7803, 7405, 6593, 5017, 1833, 3666, 7332, 6483, 4797, 1377, 2754, 5508, 2835,
    5670, 3159, 6318, 4423, 661,  1322, 2644, 5288, 2379, 4758, 1335, 2670, 5340, 2467, 4934, 1687, 3374, 6748, 5283,
    2397, 4794, 1391, 2782, 5564, 2915, 5830, 3479, 6958, 5703, 3221, 6442, 4687, 1157, 2314, 4628, 1075, 2150, 4300,
    387,  774,  1548, 3096, 6192, 4219, 237,  474,  948,  1896, 3792, 7584, 7003, 5805, 3393, 6786, 5407, 2597, 5194,
    2191, 4382, 551,  1102, 2204, 4408, 619,  1238, 2476, 4952, 1707, 3414, 6828, 5443, 2717, 5434, 2671, 5342, 2471,
    4942, 1671, 3342, 6684, 5155, 2141, 4282, 367,  734,  1468, 2936, 5872, 3579, 7158, 6135, 4085, 8170, 8143, 8069,
    7953, 7737, 7273, 6345, 4489, 777,  1554, 3108, 6216, 4235, 269,  538,  1076, 2152, 4304, 443,  886,  1772, 3544,
    7088, 6011, 3821, 7642, 7087, 5957, 3729, 7458, 6751, 5285, 2385, 4770, 1375, 2750, 5500, 2787, 5574, 2967, 5934,
    3655, 7310, 6407, 4629, 1073, 2146, 4292, 403,  806,  1612, 3224, 6448, 4731, 1261, 2522, 5044, 1907, 3814, 7628,
    7043, 5917, 3617, 7234, 6303, 4389, 593,  1186, 2372, 4744, 1291, 2582, 5164, 2115, 4230, 279,  558,  1116, 2232,
    4464, 763,  1526, 3052, 6104, 4011, 8022, 7863, 7541, 6897, 5625, 3049, 6098, 4031, 8062, 7911, 7637, 7089, 6009,
    3817, 7634, 7103, 5989, 3793, 7586, 7007, 5797, 3409, 6818, 5471, 2725, 5450, 2703, 5406, 2599, 5198, 2183, 4366,
    519,  1038, 2076, 4152, 107,  214,  428,  856,  1712, 3424, 6848, 5531, 2861, 5722, 3247, 6494, 4775, 1365, 2730,
    5460, 2739, 5478, 2775, 5550, 2887, 5774, 3335, 6670, 5127, 2069, 4138, 79,   158,  316,  632,  1264, 2528, 5056,
    1947, 3894, 7788, 7363, 6557, 4897, 1625, 3250, 6500, 4819, 1469, 2938, 5876, 3571, 7142, 6103, 4021, 8042, 7887,
    7557, 6929, 5689, 3177, 6354, 4543, 869,  1738, 3476, 6952, 5707, 3213, 6426, 4655, 1093, 2186, 4372, 563,  1126,
    2252, 4504, 811,  1622, 3244, 6488, 4779, 1357, 2714, 5428, 2675, 5350, 2519, 5038, 1863, 3726, 7452, 6691, 5213,
    2209, 4418, 671,  1342, 2684, 5368, 2539, 5078, 1975, 3950, 7900, 7587, 7005, 5793, 3417, 6834, 5503, 2789, 5578,
    2959, 5918, 3623, 7246, 6279, 4373, 561,  1122, 2244, 4488, 779,  1558, 3116, 6232, 4267, 333,  666,  1332, 2664,
    5328, 2491, 4982, 1783, 3566, 7132, 6051, 3933, 7866, 7535, 6853, 5521, 2873, 5746, 3327, 6654, 5095, 2005, 4010,
    8020, 7859, 7549, 6881, 5593, 2985, 5970, 3775, 7550, 6887, 5589, 2993, 5986, 3807, 7614, 7015, 5845, 3505, 7010,
    5855, 3493, 6986, 5775, 3333, 6666, 5135, 2053, 4106, 15,   30,   60,   120,  240,  480,  960,  1920, 3840, 7680,
    7195, 6189, 4161, 153,  306,  612,  1224, 2448, 4896, 1627, 3254, 6508, 4803, 1437, 2874, 5748, 3315, 6630, 5079,
    1973, 3946, 7892, 7603, 7037, 5857, 3545, 7090, 6015, 3813, 7626, 7055, 5893, 3601, 7202, 6239, 4261, 337,  674,
    1348, 2696, 5392, 2619, 5238, 2295, 4590, 967,  1934, 3868, 7736, 7275, 6349, 4481, 793,  1586, 3172, 6344, 4491,
    781,  1562, 3124, 6248, 4299, 397,  794,  1588, 3176, 6352, 4539, 877,  1754, 3508, 7016, 5835, 3469, 6938, 5679,
    3141, 6282, 4367, 517,  1034, 2068, 4136, 75,   150,  300,  600,  1200, 2400, 4800, 1435, 2870, 5740, 3267, 6534,
    4887, 1589, 3178, 6356, 4531, 893,  1786, 3572, 7144, 6091, 3981, 7962, 7727, 7237, 6289, 4409, 617,  1234, 2468,
    4936, 1675, 3350, 6700, 5187, 2205, 4410, 623,  1246, 2492, 4984, 1771, 3542, 7084, 5955, 3741, 7482, 6767, 5317,
    2449, 4898, 1631, 3262, 6524, 4835, 1501, 3002, 6004, 3827, 7654, 7127, 6069, 3953, 7906, 7647, 7077, 5969, 3769,
    7538, 6911, 5605, 3025, 6050, 3935, 7870, 7527, 6869, 5553, 2937, 5874, 3583, 7166, 6119, 4053, 8106, 8015, 7813,
    7441, 6713, 5225, 2249, 4498, 831,  1662, 3324, 6648, 5099, 1997, 3994, 7988, 7795, 7421, 6625, 5081, 1961, 3922,
    7844, 7507, 6845, 5473, 2777, 5554, 2943, 5886, 3559, 7118, 6023, 3861, 7722, 7247, 6277, 4369, 569,  1138, 2276,
    4552, 907,  1814, 3628, 7256, 6315, 4429, 641,  1282, 2564, 5128, 2059, 4118, 55,   110,  220,  440,  880,  1760,
    3520, 7040, 5915, 3629, 7258, 6319, 4421, 657,  1314, 2628, 5256, 2315, 4630, 1079, 2158, 4316, 419,  838,  1676,
    3352, 6704, 5243, 2285, 4570, 943,  1886, 3772, 7544, 6891, 5581, 2945, 5890, 3615, 7230, 6247, 4309, 433,  866,
    1732, 3464, 6928, 5691, 3181, 6362, 4527, 837,  1674, 3348, 6696, 5195, 2189, 4378, 559,  1118, 2236, 4472, 747,
    1494, 2988, 5976, 3755, 7510, 6839, 5493, 2801, 5602, 3039, 6078, 3943, 7886, 7559, 6933, 5681, 3193, 6386, 4607,
    997,  1994, 3988, 7976, 7755, 7309, 6401, 4633, 1065, 2130, 4260, 339,  678,  1356, 2712, 5424, 2683, 5366, 2551,
    5102, 1991, 3982, 7964, 7715, 7261, 6305, 4441, 681,  1362, 2724, 5448, 2699, 5398, 2615, 5230, 2247, 4494, 775,
    1550, 3100, 6200, 4203, 205,  410,  820,  1640, 3280, 6560, 4955, 1709, 3418, 6836, 5491, 2813, 5626, 3055, 6110,
    4007, 8014, 7815, 7445, 6705, 5241, 2281, 4562, 959,  1918, 3836, 7672, 7147, 6093, 3969, 7938, 7711, 7205, 6225,
    4281, 361,  722,  1444, 2888, 5776, 3387, 6774, 5367, 2549, 5098, 1999, 3998, 7996, 7779, 7389, 6561, 4953, 1705,
    3410, 6820, 5459, 2749, 5498, 2799, 5598, 2983, 5966, 3719, 7438, 6663, 5141, 2097, 4194, 223,  446,  892,  1784,
    3568, 7136, 6107, 4013, 8026, 7855, 7493, 6801, 5433, 2665, 5330, 2495, 4990, 1767, 3534, 7068, 5923, 3677, 7354,
    6511, 4805, 1425, 2850, 5700, 3219, 6438, 4695, 1205, 2410, 4820, 1459, 2918, 5836, 3459, 6918, 5655, 3125, 6250,
    4303, 389,  778,  1556, 3112, 6224, 4283, 365,  730,  1460, 2920, 5840, 3515, 7030, 5879, 3573, 7146, 6095, 3973,
    7946, 7695, 7173, 6161, 4153, 105,  210,  420,  840,  1680, 3360, 6720, 5275, 2349, 4698, 1199, 2398, 4796, 1379,
    2758, 5516, 2819, 5638, 3095, 6190, 4167, 149,  298,  596,  1192, 2384, 4768, 1371, 2742, 5484, 2755, 5510, 2839,
    5678, 3143, 6286, 4359, 533,  1066, 2132, 4264, 331,  662,  1324, 2648, 5296, 2427, 4854, 1527, 3054, 6108, 4003,
    8006, 7831, 7477, 6769, 5369, 2537, 5074, 1983, 3966, 7932, 7651, 7133, 6049, 3929, 7858, 7551, 6885, 5585, 3001,
    6002, 3839, 7678, 7143, 6101, 4017, 8034, 7903, 7589, 6993, 5817, 3433, 6866, 5567, 2917, 5834, 3471, 6942, 5671,
    3157, 6314, 4431, 645,  1290, 2580, 5160, 2123, 4246, 311,  622,  1244, 2488, 4976, 1787, 3574, 7148, 6083, 3997,
    7994, 7791, 7365, 6545, 4921, 1641, 3282, 6564, 4947, 1725, 3450, 6900, 5619, 3069, 6138, 4079, 8158, 8103, 8021,
    7857, 7545, 6889, 5577, 2953, 5906, 3647, 7294, 6375, 4565, 945,  1890, 3780, 7560, 6923, 5645, 3073, 6146, 4127,
    37,   74,   148,  296,  592,  1184, 2368, 4736, 1307, 2614, 5228, 2243, 4486, 791,  1582, 3164, 6328, 4459, 717,
    1434, 2868, 5736, 3275, 6550, 4919, 1653, 3306, 6612, 5043, 1917, 3834, 7668, 7155, 6141, 4065, 8130, 8095, 7973,
    7761, 7353, 6505, 4809, 1417, 2834, 5668, 3155, 6310, 4439, 693,  1386, 2772, 5544, 2891, 5782, 3383, 6766, 5319,
    2453, 4906, 1615, 3230, 6460, 4707, 1245, 2490, 4980, 1779, 3558, 7116, 6019, 3869, 7738, 7279, 6341, 4497, 825,
    1650, 3300, 6600, 5003, 1805, 3610, 7220, 6259, 4349, 481,  962,  1924, 3848, 7696, 7227, 6253, 4289, 409,  818,
    1636, 3272, 6544, 4923, 1645, 3290, 6580, 4979, 1789, 3578, 7156, 6131, 4093, 8186, 8175, 8133, 8081, 7993, 7785,
    7369, 6537, 4873, 1545, 3090, 6180, 4179, 189,  378,  756,  1512, 3024, 6048, 3931, 7862, 7543, 6901, 5617, 3065,
    6130, 4095, 8190, 8167, 8149, 8113, 8057, 7913, 7625, 7049, 5897, 3593, 7186, 6207, 4197, 209,  418,  836,  1672,
    3344, 6688, 5211, 2221, 4442, 687,  1374, 2748, 5496, 2795, 5590, 2999, 5998, 3783, 7566, 6919, 5653, 3121, 6242,
    4319, 421,  842,  1684, 3368, 6736, 5307, 2413, 4826, 1455, 2910, 5820, 3427, 6854, 5527, 2869, 5738, 3279, 6558,
    4903, 1621, 3242, 6484, 4787, 1405, 2810, 5620, 3059, 6118, 4055, 8110, 8007, 7829, 7473, 6777, 5353, 2505, 5010,
    1855, 3710, 7420, 6627, 5085, 1953, 3906, 7812, 7443, 6717, 5217, 2265, 4530, 895,  1790, 3580, 7160, 6123, 4045,
    8090, 7983, 7749, 7313, 6457, 4713, 1225, 2450, 4900, 1619, 3238, 6476, 4739, 1309, 2618, 5236, 2291, 4582, 983,
    1966, 3932, 7864, 7531, 6861, 5505, 2841, 5682, 3199, 6398, 4583, 981,  1962, 3924, 7848, 7499, 6797, 5377, 2585,
    5170, 2175, 4350, 487,  974,  1948, 3896, 7792, 7419, 6637, 5057, 1945, 3890, 7780, 7379, 6589, 4961, 1753, 3506,
    7012, 5843, 3517, 7034, 5871, 3525, 7050, 5903, 3589, 7178, 6159, 4101, 17,   34,   68,   136,  272,  544,  1088,
    2176, 4352, 539,  1078, 2156, 4312, 427,  854,  1708, 3416, 6832, 5499, 2797, 5594, 2991, 5982, 3751, 7502, 6791,
    5397, 2609, 5218, 2271, 4542, 871,  1742, 3484, 6968, 5739, 3277, 6554, 4911, 1605, 3210, 6420, 4659, 1149, 2298,
    4596, 1011, 2022, 4044, 8088, 7979, 7757, 7297, 6425, 4649, 1097, 2194, 4388, 595,  1190, 2380, 4760, 1323, 2646,
    5292, 2371, 4742, 1303, 2606, 5212, 2211, 4422, 663,  1326, 2652, 5304, 2411, 4822, 1463, 2926, 5852, 3491, 6982,
    5783, 3381, 6762, 5327, 2437, 4874, 1551, 3102, 6204, 4195, 221,  442,  884,  1768, 3536, 7072, 5979, 3757, 7514,
    6831, 5445, 2705, 5410, 2655, 5310, 2407, 4814, 1415, 2830, 5660, 3107, 6214, 4247, 309,  618,  1236, 2472, 4944,
    1723, 3446, 6892, 5571, 2973, 5946, 3695, 7390, 6567, 4949, 1713, 3426, 6852, 5523, 2877, 5754, 3311, 6622, 5031,
    1877, 3754, 7508, 6835, 5501, 2785, 5570, 2975, 5950, 3687, 7374, 6535, 4885, 1585, 3170, 6340, 4499, 829,  1658,
    3316, 6632, 5067, 1933, 3866, 7732, 7283, 6397, 4577, 985,  1970, 3940, 7880, 7563, 6925, 5633, 3097, 6194, 4223,
    229,  458,  916,  1832, 3664, 7328, 6491, 4781, 1345, 2690, 5380, 2579, 5158, 2135, 4270, 327,  654,  1308, 2616,
    5232, 2299, 4598, 1015, 2030, 4060, 8120, 8043, 7885, 7553, 6937, 5673, 3145, 6290, 4415, 613,  1226, 2452, 4904,
    1611, 3222, 6444, 4675, 1181, 2362, 4724, 1267, 2534, 5068, 1923, 3846, 7692, 7171, 6173, 4129, 89,   178,  356,
    712,  1424, 2848, 5696, 3227, 6454, 4727, 1269, 2538, 5076, 1971, 3942, 7884, 7555, 6941, 5665, 3161, 6322, 4479,
    741,  1482, 2964, 5928, 3659, 7318, 6455, 4725, 1265, 2530, 5060, 1939, 3878, 7756, 7299, 6429, 4641, 1113, 2226,
    4452, 723,  1446, 2892, 5784, 3371, 6742, 5303, 2421, 4842, 1487, 2974, 5948, 3683, 7366, 6551, 4917, 1649, 3298,
    6596, 5011, 1853, 3706, 7412, 6643, 5117, 2017, 4034, 8068, 7955, 7741, 7265, 6361, 4521, 841,  1682, 3364, 6728,
    5259, 2317, 4634, 1071, 2142, 4284, 355,  710,  1420, 2840, 5680, 3195, 6390, 4599, 1013, 2026, 4052, 8104, 8011,
    7821, 7425, 6681, 5161, 2121, 4242, 319,  638,  1276, 2552, 5104, 2043, 4086, 8172, 8131, 8093, 7969, 7769, 7337,
    6473, 4745, 1289, 2578, 5156, 2131, 4262, 343,  686,  1372, 2744, 5488, 2811, 5622, 3063, 6126, 4039, 8078, 7943,
    7701, 7217, 6265, 4329, 457,  914,  1828, 3656, 7312, 6459, 4717, 1217, 2434, 4868, 1555, 3110, 6220, 4227, 285,
    570,  1140, 2280, 4560, 955,  1910, 3820, 7640, 7083, 5965, 3713, 7426, 6687, 5157, 2129, 4258, 351,  702,  1404,
    2808, 5616, 3067, 6134, 4087, 8174, 8135, 8085, 7985, 7801, 7401, 6601, 5001, 1801, 3602, 7204, 6227, 4285, 353,
    706,  1412, 2824, 5648, 3131, 6262, 4343, 501,  1002, 2004, 4008, 8016, 7867, 7533, 6849, 5529, 2857, 5714, 3263,
    6526, 4839, 1493, 2986, 5972, 3763, 7526, 6871, 5557, 2929, 5858, 3551, 7102, 5991, 3797, 7594, 6991, 5765, 3345,
    6690, 5215, 2213, 4426, 655,  1310, 2620, 5240, 2283, 4566, 951,  1902, 3804, 7608, 7019, 5837, 3457, 6914, 5663,
    3109, 6218, 4239, 261,  522,  1044, 2088, 4176, 187,  374,  748,  1496, 2992, 5984, 3803, 7606, 7031, 5877, 3569,
    7138, 6111, 4005, 8010, 7823, 7429, 6673, 5177, 2153, 4306, 447,  894,  1788, 3576, 7152, 6139, 4077, 8154, 8111,
    8005, 7825, 7481, 6761, 5321, 2441, 4882, 1599, 3198, 6396, 4579, 989,  1978, 3956, 7912, 7627, 7053, 5889, 3609,
    7218, 6271, 4325, 465,  930,  1860, 3720, 7440, 6715, 5229, 2241, 4482, 799,  1598, 3196, 6392, 4587, 973,  1946,
    3892, 7784, 7371, 6541, 4865, 1561, 3122, 6244, 4307, 445,  890,  1780, 3560, 7120, 6075, 3949, 7898, 7599, 6981,
    5777, 3385, 6770, 5375, 2533, 5066, 1935, 3870, 7740, 7267, 6365, 4513, 857,  1714, 3428, 6856, 5515, 2829, 5658,
    3119, 6238, 4263, 341,  682,  1364, 2728, 5456, 2747, 5494, 2807, 5614, 3015, 6030, 3847, 7694, 7175, 6165, 4145,
    121,  242,  484,  968,  1936, 3872, 7744, 7323, 6445, 4673, 1177, 2354, 4708, 1235, 2470, 4940, 1667, 3334, 6668,
    5123, 2077, 4154, 111,  222,  444,  888,  1776, 3552, 7104, 6043, 3885, 7770, 7343, 6469, 4753, 1337, 2674, 5348,
    2515, 5030, 1879, 3758, 7516, 6819, 5469, 2721, 5442, 2719, 5438, 2663, 5326, 2439, 4878, 1543, 3086, 6172, 4131,
    93,   186,  372,  744,  1488, 2976, 5952, 3739, 7478, 6775, 5365, 2545, 5090, 2015, 4030, 8060, 7907, 7645, 7073,
    5977, 3753, 7506, 6847, 5477, 2769, 5538, 2911, 5822, 3431, 6862, 5511, 2837, 5674, 3151, 6302, 4391, 597,  1194,
    2388, 4776, 1355, 2710, 5420, 2627, 5254, 2327, 4654, 1095, 2190, 4380, 547,  1094, 2188, 4376, 555,  1110, 2220,
    4440, 683,  1366, 2732, 5464, 2731, 5462, 2743, 5486, 2759, 5518, 2823, 5646, 3079, 6158, 4103, 21,   42,   84,
    168,  336,  672,  1344, 2688, 5376, 2587, 5174, 2167, 4334, 455,  910,  1820, 3640, 7280, 6395, 4589, 961,  1922,
    3844, 7688, 7179, 6157, 4097, 25,   50,   100,  200,  400,  800,  1600, 3200, 6400, 4635, 1069, 2138, 4276, 371,
    742,  1484, 2968, 5936, 3707, 7414, 6647, 5109, 2033, 4066, 8132, 8083, 7997, 7777, 7385, 6569, 4937, 1673, 3346,
    6692, 5203, 2237, 4474, 751,  1502, 3004, 6008, 3819, 7638, 7095, 6005, 3825, 7650, 7135, 6053, 3921, 7842, 7519,
    6821, 5457, 2745, 5490, 2815, 5630, 3047, 6094, 3975, 7950, 7687, 7189, 6193, 4217, 233,  466,  932,  1864, 3728,
    7456, 6747, 5293, 2369, 4738, 1311, 2622, 5244, 2275, 4550, 919,  1838, 3676, 7352, 6507, 4813, 1409, 2818, 5636,
    3091, 6182, 4183, 181,  362,  724,  1448, 2896, 5792, 3419, 6838, 5495, 2805, 5610, 3023, 6046, 3879, 7758, 7303,
    6421, 4657, 1145, 2290, 4580, 979,  1958, 3916, 7832, 7467, 6733, 5249, 2329, 4658, 1151, 2302, 4604, 995,  1990,
    3980, 7960, 7723, 7245, 6273, 4377, 553,  1106, 2212, 4424, 651,  1302, 2604, 5208, 2219, 4438, 695,  1390, 2780,
    5560, 2923, 5846, 3511, 7022, 5831, 3477, 6954, 5711, 3205, 6410, 4623, 1029, 2058, 4116, 51,   102,  204,  408,
    816,  1632, 3264, 6528, 4891, 1581, 3162, 6324, 4467, 765,  1530, 3060, 6120, 4043, 8086, 7991, 7797, 7409, 6649,
    5097, 1993, 3986, 7972, 7763, 7357, 6497, 4825, 1449, 2898, 5796, 3411, 6822, 5463, 2741, 5482, 2767, 5534, 2855,
    5710, 3207, 6414, 4615, 1045, 2090, 4180, 179,  358,  716,  1432, 2864, 5728, 3291, 6582, 4983, 1781, 3562, 7124,
    6067, 3965, 7930, 7663, 7109, 6033, 3897, 7794, 7423, 6629, 5073, 1977, 3954, 7908, 7635, 7101, 5985, 3801, 7602,
    7039, 5861, 3537, 7074, 5983, 3749, 7498, 6799, 5381, 2577, 5154, 2143, 4286, 359,  718,  1436, 2872, 5744, 3323,
    6646, 5111, 2037, 4074, 8148, 8115, 8061, 7905, 7641, 7081, 5961, 3721, 7442, 6719, 5221, 2257, 4514, 863,  1726,
    3452, 6904, 5611, 3021, 6042, 3887, 7774, 7335, 6485, 4785, 1401, 2802, 5604, 3027, 6054, 3927, 7854, 7495, 6805,
    5425, 2681, 5362, 2559, 5118, 2023, 4046, 8092, 7971, 7773, 7329, 6489, 4777, 1353, 2706, 5412, 2643, 5286, 2391,
    4782, 1351, 2702, 5404, 2595, 5190, 2199, 4398, 583,  1166, 2332, 4664, 1131, 2262, 4524, 835,  1670, 3340, 6680,
    5163, 2125, 4250, 303,  606,  1212, 2424, 4848, 1531, 3062, 6124, 4035, 8070, 7959, 7733, 7281, 6393, 4585, 969,
    1938, 3876, 7752, 7307, 6413, 4609, 1049, 2098, 4196, 211,  422,  844,  1688, 3376, 6752, 5339, 2477, 4954, 1711,
    3422, 6844, 5475, 2781, 5562, 2927, 5854, 3495, 6990, 5767, 3349, 6698, 5199, 2181, 4362, 527,  1054, 2108, 4216,
    235,  470,  940,  1880, 3760, 7520, 6875, 5549, 2881, 5762, 3359, 6718, 5223, 2261, 4522, 847,  1694, 3388, 6776,
    5355, 2509, 5018, 1839, 3678, 7356, 6499, 4829, 1441, 2882, 5764, 3347, 6694, 5207, 2229, 4458, 719,  1438, 2876,
    5752, 3307, 6614, 5047, 1909, 3818, 7636, 7091, 6013, 3809, 7618, 7071, 5925, 3665, 7330, 6495, 4773, 1361, 2722,
    5444, 2707, 5414, 2647, 5294, 2375, 4750, 1287, 2574, 5148, 2083, 4166, 151,  302,  604,  1208, 2416, 4832, 1499,
    2998, 5996, 3779, 7558, 6935, 5685, 3185, 6370, 4575, 933,  1866, 3732, 7464, 6731, 5261, 2305, 4610, 1055, 2110,
    4220, 227,  454,  908,  1816, 3632, 7264, 6363, 4525, 833,  1666, 3332, 6664, 5131, 2061, 4122, 47,   94,   188,
    376,  752,  1504, 3008, 6016, 3867, 7734, 7287, 6389, 4593, 1017, 2034, 4068, 8136, 8075, 7949, 7681, 7193, 6185,
    4169, 137,  274,  548,  1096, 2192, 4384, 603,  1206, 2412, 4824, 1451, 2902, 5804, 3395, 6790, 5399, 2613, 5226,
    2255, 4510, 807,  1614, 3228, 6456, 4715, 1229, 2458, 4916, 1651, 3302, 6604, 4995, 1821, 3642, 7284, 6387, 4605,
    993,  1986, 3972, 7944, 7691, 7181, 6145, 4121, 41,   82,   164,  328,  656,  1312, 2624, 5248, 2331, 4662, 1143,
    2286, 4572, 931,  1862, 3724, 7448, 6699, 5197, 2177, 4354, 543,  1086, 2172, 4344, 491,  982,  1964, 3928, 7856,
    7547, 6893, 5569, 2969, 5938, 3711, 7422, 6631, 5077, 1969, 3938, 7876, 7571, 6973, 5729, 3289, 6578, 4991, 1765,
    3530, 7060, 5939, 3709, 7418, 6639, 5061, 1937, 3874, 7748, 7315, 6461, 4705, 1241, 2482, 4964, 1747, 3494, 6988,
    5763, 3357, 6714, 5231, 2245, 4490, 783,  1566, 3132, 6264, 4331, 461,  922,  1844, 3688, 7376, 6587, 4973, 1729,
    3458, 6916, 5651, 3133, 6266, 4335, 453,  906,  1812, 3624, 7248, 6331, 4461, 705,  1410, 2820, 5640, 3083, 6166,
    4151, 117,  234,  468,  936,  1872, 3744, 7488, 6811, 5421, 2625, 5250, 2335, 4670, 1127, 2254, 4508, 803,  1606,
    3212, 6424, 4651, 1101, 2202, 4404, 627,  1254, 2508, 5016, 1835, 3670, 7340, 6467, 4765, 1313, 2626, 5252, 2323,
    4646, 1111, 2222, 4444, 675,  1350, 2700, 5400, 2603, 5206, 2231, 4462, 711,  1422, 2844, 5688, 3179, 6358, 4535,
    885,  1770, 3540, 7080, 5963, 3725, 7450, 6703, 5189, 2193, 4386, 607,  1214, 2428, 4856, 1515, 3030, 6060, 3907,
    7814, 7447, 6709, 5233, 2297, 4594, 1023, 2046, 4092, 8184, 8171, 8141, 8065, 7961, 7721, 7241, 6281, 4361, 521,
    1042, 2084, 4168, 139,  278,  556,  1112, 2224, 4448, 731,  1462, 2924, 5848, 3499, 6998, 5815, 3445, 6890, 5583,
    2949, 5898, 3599, 7198, 6183, 4181, 177,  354,  708,  1416, 2832, 5664, 3163, 6326, 4471, 757,  1514, 3028, 6056,
    3915, 7830, 7479, 6773, 5361, 2553, 5106, 2047, 4094, 8188, 8163, 8157, 8097, 8025, 7849, 7497, 6793, 5385, 2569,
    5138, 2111, 4222, 231,  462,  924,  1848, 3696, 7392, 6619, 5037, 1857, 3714, 7428, 6675, 5181, 2145, 4290, 415,
    830,  1660, 3320, 6640, 5115, 2029, 4058, 8116, 8051, 7933, 7649, 7129, 6057, 3913, 7826, 7487, 6757, 5329, 2489,
    4978, 1791, 3582, 7164, 6115, 4061, 8122, 8047, 7877, 7569, 6969, 5737, 3273, 6546, 4927, 1637, 3274, 6548, 4915,
    1661, 3322, 6644, 5107, 2045, 4090, 8180, 8179, 8189, 8161, 8153, 8105, 8009, 7817, 7433, 6665, 5129, 2057, 4114,
    63,   126,  252,  504,  1008, 2016, 4032, 8064, 7963, 7725, 7233, 6297, 4393, 585,  1170, 2340, 4680, 1163, 2326,
    4652, 1091, 2182, 4364, 515,  1030, 2060, 4120, 43,   86,   172,  344,  688,  1376, 2752, 5504, 2843, 5686, 3191,
    6382, 4551, 917,  1834, 3668, 7336, 6475, 4749, 1281, 2562, 5124, 2067, 4134, 87,   174,  348,  696,  1392, 2784,
    5568, 2971, 5942, 3703, 7406, 6599, 5013, 1841, 3682, 7364, 6547, 4925, 1633, 3266, 6532, 4883, 1597, 3194, 6388,
    4595, 1021, 2042, 4084, 8168, 8139, 8077, 7937, 7705, 7209, 6217, 4233, 265,  530,  1060, 2120, 4240, 315,  630,
    1260, 2520, 5040, 1915, 3830, 7660, 7107, 6045, 3873, 7746, 7327, 6437, 4689, 1209, 2418, 4836, 1491, 2982, 5964,
    3715, 7430, 6679, 5173, 2161, 4322, 479,  958,  1916, 3832, 7664, 7163, 6125, 4033, 8066, 7967, 7717, 7249, 6329,
    4457, 713,  1426, 2852, 5704, 3211, 6422, 4663, 1141, 2282, 4564, 947,  1894, 3788, 7576, 6955, 5709, 3201, 6402,
    4639, 1061, 2122, 4244, 307,  614,  1228, 2456, 4912, 1659, 3318, 6636, 5059, 1949, 3898, 7796, 7411, 6653, 5089,
    2009, 4018, 8036, 7891, 7613, 7009, 5849, 3497, 6994, 5823, 3429, 6858, 5519, 2821, 5642, 3087, 6174, 4135, 85,
    170,  340,  680,  1360, 2720, 5440, 2715, 5430, 2679, 5358, 2503, 5006, 1799, 3598, 7196, 6179, 4189, 161,  322,
    644,  1288, 2576, 5152, 2139, 4278, 375,  750,  1500, 3000, 6000, 3835, 7670, 7159, 6133, 4081, 8162, 8159, 8101,
    8017, 7865, 7529, 6857, 5513, 2825, 5650, 3135, 6270, 4327, 469,  938,  1876, 3752, 7504, 6843, 5485, 2753, 5506,
    2847, 5694, 3175, 6350, 4487, 789,  1578, 3156, 6312, 4427, 653,  1306, 2612, 5224, 2251, 4502, 823,  1646, 3292,
    6584, 4971, 1741, 3482, 6964, 5747, 3325, 6650, 5103, 1989, 3978, 7956, 7731, 7293, 6369, 4569, 937,  1874, 3748,
    7496, 6795, 5389, 2561, 5122, 2079, 4158, 103,  206,  412,  824,  1648, 3296, 6592, 5019, 1837, 3674, 7348, 6515,
    4861, 1505, 3010, 6020, 3859, 7718, 7255, 6325, 4465, 761,  1522, 3044, 6088, 3979, 7958, 7735, 7285, 6385, 4601,
    1001, 2002, 4004, 8008, 7819, 7437, 6657, 5145, 2089, 4178, 191,  382,  764,  1528, 3056, 6112, 4059, 8118, 8055,
    7925, 7665, 7161, 6121, 4041, 8082, 7999, 7781, 7377, 6585, 4969, 1737, 3474, 6948, 5715, 3261, 6522, 4847, 1477,
    2954, 5908, 3635, 7270, 6359, 4533, 881,  1762, 3524, 7048, 5899, 3597, 7194, 6191, 4165, 145,  290,  580,  1160,
    2320, 4640, 1115, 2230, 4460, 707,  1414, 2828, 5656, 3115, 6230, 4279, 373,  746,  1492, 2984, 5968, 3771, 7542,
    6903, 5621, 3057, 6114, 4063, 8126, 8039, 7893, 7601, 7033, 5865, 3529, 7058, 5951, 3685, 7370, 6543, 4869, 1553,
    3106, 6212, 4243, 317,  634,  1268, 2536, 5072, 1979, 3958, 7916, 7619, 7069, 5921, 3673, 7346, 6527, 4837, 1489,
    2978, 5956, 3731, 7462, 6743, 5301, 2417, 4834, 1503, 3006, 6012, 3811, 7622, 7063, 5941, 3697, 7394, 6623, 5029,
    1873, 3746, 7492, 6803, 5437, 2657, 5314, 2463, 4926, 1639, 3278, 6556, 4899, 1629, 3258, 6516, 4851, 1533, 3066,
    6132, 4083, 8166, 8151, 8117, 8049, 7929, 7657, 7113, 6025, 3849, 7698, 7231, 6245, 4305, 441,  882,  1764, 3528,
    7056, 5947, 3693, 7386, 6575, 4933, 1681, 3362, 6724, 5267, 2365, 4730, 1263, 2526, 5052, 1891, 3782, 7564, 6915,
    5661, 3105, 6210, 4255, 293,  586,  1172, 2344, 4688, 1211, 2422, 4844, 1475, 2950, 5900, 3587, 7174, 6167, 4149,
    113,  226,  452,  904,  1808, 3616, 7232, 6299, 4397, 577,  1154, 2308, 4616, 1035, 2070, 4140, 67,   134,  268,
    536,  1072, 2144, 4288, 411,  822,  1644, 3288, 6576, 4987, 1773, 3546, 7092, 6003, 3837, 7674, 7151, 6085, 3985,
    7970, 7775, 7333, 6481, 4793, 1385, 2770, 5540, 2899, 5798, 3415, 6830, 5447, 2709, 5418, 2639, 5278, 2343, 4686,
    1159, 2318, 4636, 1059, 2118, 4236, 259,  518,  1036, 2072, 4144, 123,  246,  492,  984,  1968, 3936, 7872, 7579,
    6957, 5697, 3225, 6450, 4735, 1253, 2506, 5012, 1843, 3686, 7372, 6531, 4893, 1569, 3138, 6276, 4371, 573,  1146,
    2292, 4584, 971,  1942, 3884, 7768, 7339, 6477, 4737, 1305, 2610, 5220, 2259, 4518, 855,  1710, 3420, 6840, 5483,
    2765, 5530, 2863, 5726, 3239, 6478, 4743, 1301, 2602, 5204, 2227, 4454, 727,  1454, 2908, 5816, 3435, 6870, 5559,
    2933, 5866, 3535, 7070, 5927, 3669, 7338, 6479, 4741, 1297, 2594, 5188, 2195, 4390, 599,  1198, 2396, 4792, 1387,
    2774, 5548, 2883, 5766, 3351, 6702, 5191, 2197, 4394, 591,  1182, 2364, 4728, 1259, 2518, 5036, 1859, 3718, 7436,
    6659, 5149, 2081, 4162, 159,  318,  636,  1272, 2544, 5088, 2011, 4022, 8044, 7875, 7581, 6945, 5721, 3241, 6482,
    4799, 1381, 2762, 5524, 2867, 5734, 3287, 6574, 4935, 1685, 3370, 6740, 5299, 2429, 4858, 1519, 3038, 6076, 3939,
    7878, 7575, 6965, 5745, 3321, 6642, 5119, 2021, 4042, 8084, 7987, 7805, 7393, 6617, 5033, 1865, 3730, 7460, 6739,
    5309, 2401, 4802, 1439, 2878, 5756, 3299, 6598, 5015, 1845, 3690, 7380, 6579, 4989, 1761, 3522, 7044, 5907, 3645,
    7290, 6383, 4549, 913,  1826, 3652, 7304, 6411, 4621, 1025, 2050, 4100, 19,   38,   76,   152,  304,  608,  1216,
    2432, 4864, 1563, 3126, 6252, 4291, 413,  826,  1652, 3304, 6608, 5051, 1901, 3802, 7604, 7027, 5885, 3553, 7106,
    6047, 3877, 7754, 7311, 6405, 4625, 1081, 2162, 4324, 467,  934,  1868, 3736, 7472, 6779, 5357, 2497, 4994, 1823,
    3646, 7292, 6371, 4573, 929,  1858, 3716, 7432, 6667, 5133, 2049, 4098, 31,   62,   124,  248,  496,  992,  1984,
    3968, 7936, 7707, 7213, 6209, 4249, 297,  594,  1188, 2376, 4752, 1339, 2678, 5356, 2499, 4998, 1815, 3630, 7260,
    6307, 4445, 673,  1346, 2692, 5384, 2571, 5142, 2103, 4206, 199,  398,  796,  1592, 3184, 6368, 4571, 941,  1882,
    3764, 7528, 6859, 5517, 2817, 5634, 3103, 6206, 4199, 213,  426,  852,  1704, 3408, 6816, 5467, 2733, 5466, 2735,
    5470, 2727, 5454, 2695, 5390, 2567, 5134, 2055, 4110, 7,    14,   28,   56,   112,  224,  448,  896,  1792, 3584,
    7168, 6171, 4141, 65,   130,  260,  520,  1040, 2080, 4160, 155,  310,  620,  1240, 2480, 4960, 1755, 3510, 7020,
    5827, 3485, 6970, 5743, 3269, 6538, 4879, 1541, 3082, 6164, 4147, 125,  250,  500,  1000, 2000, 4000, 8000, 7835,
    7469, 6721, 5273, 2345, 4690, 1215, 2430, 4860, 1507, 3014, 6028, 3843, 7686, 7191, 6197, 4209, 249,  498,  996,
    1992, 3984, 7968, 7771, 7341, 6465, 4761, 1321, 2642, 5284, 2387, 4774, 1367, 2734, 5468, 2723, 5446, 2711, 5422,
    2631, 5262, 2311, 4622, 1031, 2062, 4124, 35,   70,   140,  280,  560,  1120, 2240, 4480, 795,  1590, 3180, 6360,
    4523, 845,  1690, 3380, 6760, 5323, 2445, 4890, 1583, 3166, 6332, 4451, 733,  1466, 2932, 5864, 3531, 7062, 5943,
    3701, 7402, 6607, 4997, 1809, 3618, 7236, 6291, 4413, 609,  1218, 2436, 4872, 1547, 3094, 6188, 4163, 157,  314,
    628,  1256, 2512, 5024, 1883, 3766, 7532, 6851, 5533, 2849, 5698, 3231, 6462, 4711, 1237, 2474, 4948, 1715, 3430,
    6860, 5507, 2845, 5690, 3183, 6366, 4519, 853,  1706, 3412, 6824, 5451, 2701, 5402, 2607, 5214, 2215, 4430, 647,
    1294, 2588, 5176, 2155, 4310, 439,  878,  1756, 3512, 7024, 5883, 3565, 7130, 6063, 3909, 7818, 7439, 6661, 5137,
    2105, 4210, 255,  510,  1020, 2040, 4080, 8160, 8155, 8109, 8001, 7833, 7465, 6729, 5257, 2313, 4626, 1087, 2174,
    4348, 483,  966,  1932, 3864, 7728, 7291, 6381, 4545, 921,  1842, 3684, 7368, 6539, 4877, 1537, 3074, 6148, 4115,
    61,   122,  244,  488,  976,  1952, 3904, 7808, 7451, 6701, 5185, 2201, 4402, 639,  1278, 2556, 5112, 2027, 4054,
    8108, 8003, 7837, 7457, 6745, 5289, 2377, 4754, 1343, 2686, 5372, 2531, 5062, 1943, 3886, 7772, 7331, 6493, 4769,
    1369, 2738, 5476, 2771, 5542, 2903, 5806, 3399, 6798, 5383, 2581, 5162, 2127, 4254, 295,  590,  1180, 2360, 4720,
    1275, 2550, 5100, 1987, 3974, 7948, 7683, 7197, 6177, 4185, 169,  338,  676,  1352, 2704, 5408, 2651, 5302, 2423,
    4846, 1479, 2958, 5916, 3619, 7238, 6295, 4405, 625,  1250, 2500, 5000, 1803, 3606, 7212, 6211, 4253, 289,  578,
    1156, 2312, 4624, 1083, 2166, 4332, 451,  902,  1804, 3608, 7216, 6267, 4333, 449,  898,  1796, 3592, 7184, 6203,
    4205, 193,  386,  772,  1544, 3088, 6176, 4187, 173,  346,  692,  1384, 2768, 5536, 2907, 5814, 3447, 6894, 5575,
    2965, 5930, 3663, 7326, 6439, 4693, 1201, 2402, 4804, 1427, 2854, 5708, 3203, 6406, 4631, 1077, 2154, 4308, 435,
    870,  1740, 3480, 6960, 5755, 3309, 6618, 5039, 1861, 3722, 7444, 6707, 5245, 2273, 4546, 927,  1854, 3708, 7416,
    6635, 5069, 1921, 3842, 7684, 7187, 6205, 4193, 217,  434,  868,  1736, 3472, 6944, 5723, 3245, 6490, 4783, 1349,
    2698, 5396, 2611, 5222, 2263, 4526, 839,  1678, 3356, 6712, 5227, 2253, 4506, 815,  1630, 3260, 6520, 4843, 1485,
    2970, 5940, 3699, 7398, 6615, 5045, 1905, 3810, 7620, 7059, 5949, 3681, 7362, 6559, 4901, 1617, 3234, 6468, 4755,
    1341, 2682, 5364, 2547, 5094, 2007, 4014, 8028, 7843, 7517, 6817, 5465, 2729, 5458, 2751, 5502, 2791, 5582, 2951,
    5902, 3591, 7182, 6151, 4117, 49,   98,   196,  392,  784,  1568, 3136, 6272, 4379, 557,  1114, 2228, 4456, 715,
    1430, 2860, 5720, 3243, 6486, 4791, 1397, 2794, 5588, 2995, 5990, 3799, 7598, 6983, 5781, 3377, 6754, 5343, 2469,
    4938, 1679, 3358, 6716, 5219, 2269, 4538, 879,  1758, 3516, 7032, 5867, 3533, 7066, 5935, 3653, 7306, 6415, 4613,
    1041, 2082, 4164, 147,  294,  588,  1176, 2352, 4704, 1243, 2486, 4972, 1731, 3462, 6924, 5635, 3101, 6202, 4207,
    197,  394,  788,  1576, 3152, 6304, 4443, 685,  1370, 2740, 5480, 2763, 5526, 2871, 5742, 3271, 6542, 4871, 1557,
    3114, 6228, 4275, 381,  762,  1524, 3048, 6096, 4027, 8054, 7927, 7669, 7153, 6137, 4073, 8146, 8127, 8037, 7889,
    7609, 7017, 5833, 3465, 6930, 5695, 3173, 6346, 4495, 773,  1546, 3092, 6184, 4171, 141,  282,  564,  1128, 2256,
    4512, 859,  1718, 3436, 6872, 5547, 2893, 5786, 3375, 6750, 5287, 2389, 4778, 1359, 2718, 5436, 2659, 5318, 2455,
    4910, 1607, 3214, 6428, 4643, 1117, 2234, 4468, 755,  1510, 3020, 6040, 3883, 7766, 7351, 6517, 4849, 1529, 3058,
    6116, 4051, 8102, 8023, 7861, 7537, 6905, 5609, 3017, 6034, 3903, 7806, 7399, 6613, 5041, 1913, 3826, 7652, 7123,
    6077, 3937, 7874, 7583, 6949, 5713, 3257, 6514, 4863, 1509, 3018, 6036, 3891, 7782, 7383, 6581, 4977, 1785, 3570,
    7140, 6099, 4029, 8058, 7919, 7621, 7057, 5945, 3689, 7378, 6591, 4965, 1745, 3490, 6980, 5779, 3389, 6778, 5359,
    2501, 5002, 1807, 3614, 7228, 6243, 4317, 417,  834,  1668, 3336, 6672, 5179, 2157, 4314, 431,  862,  1724, 3448,
    6896, 5627, 3053, 6106, 4015, 8030, 7847, 7509, 6833, 5497, 2793, 5586, 3007, 6014, 3815, 7630, 7047, 5909, 3633,
    7266, 6367, 4517, 849,  1698, 3396, 6792, 5387, 2573, 5146, 2095, 4190, 167,  334,  668,  1336, 2672, 5344, 2523,
    5046, 1911, 3822, 7644, 7075, 5981, 3745, 7490, 6815, 5413, 2641, 5282, 2399, 4798, 1383, 2766, 5532, 2851, 5702,
    3223, 6446, 4679, 1173, 2346, 4692, 1203, 2406, 4812, 1411, 2822, 5644, 3075, 6150, 4119, 53,   106,  212,  424,
    848,  1696, 3392, 6784, 5403, 2605, 5210, 2223, 4446, 679,  1358, 2716, 5432, 2667, 5334, 2487, 4974, 1735, 3470,
    6940, 5667, 3165, 6330, 4463, 709,  1418, 2836, 5672, 3147, 6294, 4407, 629,  1258, 2516, 5032, 1867, 3734, 7468,
    6723, 5277, 2337, 4674, 1183, 2366, 4732, 1251, 2502, 5004, 1795, 3590, 7180, 6147, 4125, 33,   66,   132,  264,
    528,  1056, 2112, 4224, 283,  566,  1132, 2264, 4528, 891,  1782, 3564, 7128, 6059, 3917, 7834, 7471, 6725, 5265,
    2361, 4722, 1279, 2558, 5116, 2019, 4038, 8076, 7939, 7709, 7201, 6233, 4265, 329,  658,  1316, 2632, 5264, 2363,
    4726, 1271, 2542, 5084, 1955, 3910, 7820, 7427, 6685, 5153, 2137, 4274, 383,  766,  1532, 3064, 6128, 4091, 8182,
    8183, 8181, 8177, 8185, 8169, 8137, 8073, 7945, 7689, 7177, 6153, 4105, 9,    18,   36,   72,   144,  288,  576,
    1152, 2304, 4608, 1051, 2102, 4204, 195,  390,  780,  1560, 3120, 6240, 4315, 429,  858,  1716, 3432, 6864, 5563,
    2925, 5850, 3503, 7006, 5799, 3413, 6826, 5455, 2693, 5386, 2575, 5150, 2087, 4174, 135,  270,  540,  1080, 2160,
    4320, 475,  950,  1900, 3800, 7600, 7035, 5869, 3521, 7042, 5919, 3621, 7242, 6287, 4357, 529,  1058, 2116, 4232,
    267,  534,  1068, 2136, 4272, 379,  758,  1516, 3032, 6064, 3963, 7926, 7671, 7157, 6129, 4089, 8178, 8191, 8165,
    8145, 8121, 8041, 7881, 7561, 6921, 5641, 3081, 6162, 4159, 101,  202,  404,  808,  1616, 3232, 6464, 4763, 1325,
    2650, 5300, 2419, 4838, 1495, 2990, 5980, 3747, 7494, 6807, 5429, 2673, 5346, 2527, 5054, 1895, 3790, 7580, 6947,
    5725, 3233, 6466, 4767, 1317, 2634, 5268, 2355, 4710, 1239, 2478, 4956, 1699, 3398, 6796, 5379, 2589, 5178, 2159,
    4318, 423,  846,  1692, 3384, 6768, 5371, 2541, 5082, 1967, 3934, 7868, 7523, 6877, 5537, 2905, 5810, 3455, 6910,
    5607, 3029, 6058, 3919, 7838, 7463, 6741, 5297, 2425, 4850, 1535, 3070, 6140, 4067, 8134, 8087, 7989, 7793, 7417,
    6633, 5065, 1929, 3858, 7716, 7251, 6333, 4449, 729,  1458, 2916, 5832, 3467, 6934, 5687, 3189, 6378, 4559, 901,
    1802, 3604, 7208, 6219, 4237, 257,  514,  1028, 2056, 4112, 59,   118,  236,  472,  944,  1888, 3776, 7552, 6939,
    5677, 3137, 6274, 4383, 549,  1098, 2196, 4392, 587,  1174, 2348, 4696, 1195, 2390, 4780, 1347, 2694, 5388, 2563,
    5126, 2071, 4142, 71,   142,  284,  568,  1136, 2272, 4544, 923,  1846, 3692, 7384, 6571, 4941, 1665, 3330, 6660,
    5139, 2109, 4218, 239,  478,  956,  1912, 3824, 7648, 7131, 6061, 3905, 7810, 7455, 6693, 5201, 2233, 4466, 767,
    1534, 3068, 6136, 4075, 8150, 8119, 8053, 7921, 7673, 7145, 6089, 3977, 7954, 7743, 7269, 6353, 4537, 873,  1746,
    3492, 6984, 5771, 3341, 6682, 5167, 2117, 4234, 271,  542,  1084, 2168, 4336, 507,  1014, 2028, 4056, 8112, 8059,
    7917, 7617, 7065, 5929, 3657, 7314, 6463, 4709, 1233, 2466, 4932, 1683, 3366, 6732, 5251, 2333, 4666, 1135, 2270,
    4540, 867,  1734, 3468, 6936, 5675, 3149, 6298, 4399, 581,  1162, 2324, 4648, 1099, 2198, 4396, 579,  1158, 2316,
    4632, 1067, 2134, 4268, 323,  646,  1292, 2584, 5168, 2171, 4342, 503,  1006, 2012, 4024, 8048, 7931, 7661, 7105,
    6041, 3881, 7762, 7359, 6501, 4817, 1465, 2930, 5860, 3539, 7078, 5975, 3765, 7530, 6863, 5509, 2833, 5666, 3167,
    6334, 4455, 725,  1450, 2900, 5800, 3403, 6806, 5431, 2677, 5354, 2511, 5022, 1831, 3662, 7324, 6435, 4701, 1185,
    2370, 4740, 1299, 2598, 5196, 2179, 4358, 535,  1070, 2140, 4280, 363,  726,  1452, 2904, 5808, 3451, 6902, 5623,
    3061, 6122, 4047, 8094, 7975, 7765, 7345, 6521, 4841, 1481, 2962, 5924, 3667, 7334, 6487, 4789, 1393, 2786, 5572,
    2963, 5926, 3671, 7342, 6471, 4757, 1329, 2658, 5316, 2451, 4902, 1623, 3246, 6492, 4771, 1373, 2746, 5492, 2803,
    5606, 3031, 6062, 3911, 7822, 7431, 6677, 5169, 2169, 4338, 511,  1022, 2044, 4088, 8176, 8187, 8173, 8129, 8089,
    7977, 7753, 7305, 6409, 4617, 1033, 2066, 4132, 83,   166,  332,  664,  1328, 2656, 5312, 2459, 4918, 1655, 3310,
    6620, 5027, 1885, 3770, 7540, 6899, 5629, 3041, 6082, 3999, 7998, 7783, 7381, 6577, 4985, 1769, 3538, 7076, 5971,
    3773, 7546, 6895, 5573, 2961, 5922, 3679, 7358, 6503, 4821, 1457, 2914, 5828, 3475, 6950, 5719, 3253, 6506, 4815,
    1413, 2826, 5652, 3123, 6246, 4311, 437,  874,  1748, 3496, 6992, 5819, 3437, 6874, 5551, 2885, 5770, 3343, 6686,
    5159, 2133, 4266, 335,  670,  1340, 2680, 5360, 2555, 5110, 2039, 4078, 8156, 8099, 8029, 7841, 7513, 6825, 5449,
    2697, 5394, 2623, 5246, 2279, 4558, 903,  1806, 3612, 7224, 6251, 4301, 385,  770,  1540, 3080, 6160, 4155, 109,
    218,  436,  872,  1744, 3488, 6976, 5787, 3373, 6746, 5295, 2373, 4746, 1295, 2590, 5180, 2147, 4294, 407,  814,
    1628, 3256, 6512, 4859, 1517, 3034, 6068, 3955, 7910, 7639, 7093, 6001, 3833, 7666, 7167, 6117, 4049, 8098, 8031,
    7845, 7505, 6841, 5481, 2761, 5522, 2879, 5758, 3303, 6606, 4999, 1813, 3626, 7252, 6323, 4477, 737,  1474, 2948,
    5896, 3595, 7190, 6199, 4213, 241,  482,  964,  1928, 3856, 7712, 7259, 6317, 4417, 665,  1330, 2660, 5320, 2443,
    4886, 1591, 3182, 6364, 4515, 861,  1722, 3444, 6888, 5579, 2957, 5914, 3631, 7262, 6311, 4437, 689,  1378, 2756,
    5512, 2827, 5654, 3127, 6254, 4295, 405,  810,  1620, 3240, 6480, 4795, 1389, 2778, 5556, 2931, 5862, 3543, 7086,
    5959, 3733, 7466, 6735, 5253, 2321, 4642, 1119, 2238, 4476, 739,  1478, 2956, 5912, 3627, 7254, 6327, 4469, 753,
    1506, 3012, 6024, 3851, 7702, 7223, 6261, 4337, 505,  1010, 2020, 4040, 8080, 7995, 7789, 7361, 6553, 4905, 1609,
    3218, 6436, 4691, 1213, 2426, 4852, 1523, 3046, 6092, 3971, 7942, 7703, 7221, 6257, 4345, 489,  978,  1956, 3912,
    7824, 7483, 6765, 5313, 2457, 4914, 1663, 3326, 6652, 5091, 2013, 4026, 8052, 7923, 7677, 7137, 6105, 4009, 8018,
    7871, 7525, 6865, 5561, 2921, 5842, 3519, 7038, 5863, 3541, 7082, 5967, 3717, 7434, 6671, 5125, 2065, 4130, 95,
    190,  380,  760,  1520, 3040, 6080, 3995, 7990, 7799, 7413, 6641, 5113, 2025, 4050, 8100, 8019, 7869, 7521, 6873,
    5545, 2889, 5778, 3391, 6782, 5351, 2517, 5034, 1871, 3742, 7484, 6755, 5341, 2465, 4930, 1695, 3390, 6780, 5347,
    2525, 5050, 1903, 3806, 7612, 7011, 5853, 3489, 6978, 5791, 3365, 6730, 5263, 2309, 4618, 1039, 2078, 4156, 99,
    198,  396,  792,  1584, 3168, 6336, 4507, 813,  1626, 3252, 6504, 4811, 1421, 2842, 5684, 3187, 6374, 4567, 949,
    1898, 3796, 7592, 6987, 5773, 3329, 6658, 5151, 2085, 4170, 143,  286,  572,  1144, 2288, 4576, 987,  1974, 3948,
    7896, 7595, 6989, 5761, 3353, 6706, 5247, 2277, 4554, 911,  1822, 3644, 7288, 6379, 4557, 897,  1794, 3588, 7176,
    6155, 4109};

const uint16_t gf2_13_logTab[8192] = {
    8192, 0,    1,    934,  2,    1868, 935,  6336, 3,    7270, 1869, 490,  936,  93,   6337, 2802, 4,    3736, 7271,
    6206, 1870, 4481, 491,  1027, 937,  4508, 94,   13,   6338, 1424, 2803, 6263, 5,    7197, 3737, 6429, 7272, 3439,
    6207, 2358, 1871, 5081, 4482, 5442, 492,  947,  1028, 5013, 938,  6826, 4509, 4670, 95,   7140, 14,   3034, 6339,
    1961, 1425, 7477, 2804, 6574, 6264, 5415, 6,    6349, 7198, 5963, 3738, 980,  6430, 7508, 7273, 1407, 3440, 2895,
    6208, 220,  2359, 2653, 1872, 186,  5082, 7760, 4483, 5604, 5443, 5466, 493,  3968, 948,  1523, 1029, 4408, 5014,
    8074, 939,  290,  6827, 8131, 4510, 7363, 4671, 5707, 96,   3292, 7141, 2626, 15,   7865, 3035, 4373, 6340, 5947,
    1962, 2379, 1426, 5188, 7478, 1881, 2805, 4351, 6575, 6015, 6265, 6376, 5416, 583,  7,    1517, 6350, 2335, 7199,
    1179, 5964, 7310, 3739, 5036, 981,  5285, 6431, 6949, 7509, 8161, 7274, 5791, 1408, 6881, 3441, 3313, 2896, 4971,
    6209, 2815, 221,  6356, 2360, 6477, 2654, 6122, 1873, 5622, 187,  1224, 5083, 874,  7761, 7099, 4484, 6641, 5605,
    754,  5444, 6696, 5467, 106,  494,  5307, 3969, 4719, 949,  4601, 1524, 608,  1030, 441,  4409, 4226, 5015, 3560,
    8075, 5748, 940,  6689, 291,  7283, 6828, 6897, 8132, 6299, 4511, 251,  7364, 322,  4672, 3158, 5708, 1914, 97,
    3587, 3293, 4873, 7142, 6317, 2627, 1154, 16,   6753, 7866, 2341, 3036, 3829, 4374, 3226, 6341, 817,  5948, 4998,
    1963, 3914, 2380, 5342, 1427, 4574, 5189, 4902, 7479, 2457, 1882, 7527, 2806, 7928, 4352, 1120, 6576, 503,  6016,
    832,  6266, 6400, 6377, 1584, 5417, 645,  584,  6538, 8,    7472, 1518, 6010, 6351, 4221, 2336, 1579, 7200, 5503,
    1180, 7334, 5965, 2518, 7311, 7570, 3740, 771,  5037, 671,  982,  2054, 5286, 2580, 6432, 1766, 6950, 7205, 7510,
    4122, 8162, 1437, 7275, 6667, 5792, 1751, 1409, 5932, 6882, 6626, 3442, 6276, 3314, 1978, 2897, 298,  4972, 4848,
    6210, 270,  2816, 5571, 222,  3852, 6357, 3391, 2361, 1083, 6478, 5508, 2655, 5836, 6123, 4072, 1874, 825,  5623,
    7623, 188,  26,   1225, 3929, 5084, 7233, 875,  3333, 7762, 2751, 7100, 7831, 4485, 2848, 6642, 3127, 5606, 4335,
    755,  4092, 5445, 524,  6697, 1185, 5468, 1256, 107,  4139, 495,  4160, 5308, 4053, 3970, 2130, 4720, 4763, 950,
    3193, 4602, 7687, 1525, 3275, 609,  2496, 1031, 1389, 442,  4521, 4410, 5807, 4227, 5630, 5016, 2088, 3561, 7339,
    8076, 6919, 5749, 7251, 941,  7859, 6690, 2451, 292,  3269, 7284, 792,  6829, 53,   6898, 377,  8133, 2874, 6300,
    2113, 4512, 904,  252,  2553, 7365, 7967, 323,  7883, 4673, 3532, 3159, 5970, 5709, 6219, 1915, 5357, 98,   7056,
    3588, 3056, 3294, 3611, 4874, 7411, 7143, 1651, 6318, 3749, 2628, 7290, 1155, 7064, 17,   3076, 6754, 6725, 7867,
    7815, 2342, 6522, 3037, 5905, 3830, 2523, 4375, 4303, 3227, 4247, 6342, 6682, 818,  6675, 5949, 5174, 4999, 4494,
    1964, 4108, 3915, 1375, 2381, 5160, 5343, 1637, 1428, 4278, 4575, 6241, 5190, 5653, 4903, 1059, 7480, 1542, 2458,
    7316, 1883, 1342, 7528, 5535, 2807, 3524, 7929, 6556, 4353, 2158, 1121, 3708, 6577, 8033, 504,  5106, 6017, 798,
    833,  1808, 6267, 1040, 6401, 2395, 6378, 4168, 1585, 7630, 5418, 8007, 646,  7575, 585,  1688, 6539, 7743, 9,
    486,  7473, 5438, 1519, 2891, 6011, 2622, 6352, 5281, 4222, 750,  2337, 318,  1580, 4898, 7201, 7330, 5504, 1974,
    1181, 3329, 7335, 7683, 5966, 373,  2519, 3745, 7312, 1371, 7571, 5102, 3741, 746,  772,  4458, 5038, 7490, 672,
    2472, 983,  4642, 2055, 4462, 5287, 6835, 2581, 3092, 6433, 2742, 1767, 2696, 6951, 2013, 7206, 1732, 7511, 3018,
    4123, 776,  8163, 6040, 1438, 1454, 7276, 5956, 6668, 7616, 5793, 7609, 1752, 4834, 1410, 5428, 5933, 7494, 6883,
    1106, 6627, 6108, 3443, 2571, 6277, 3794, 3315, 4444, 1979, 6094, 2898, 2003, 299,  5042, 4973, 2309, 4849, 5255,
    6211, 6469, 271,  1303, 2817, 3948, 5572, 2276, 223,  2923, 3853, 2476, 6358, 59,   3392, 2933, 2362, 6658, 1084,
    5212, 6479, 7175, 5509, 195,  2656, 1993, 5837, 676,  6124, 1556, 4073, 6587, 1875, 3028, 826,  602,  5624, 3385,
    7624, 6516, 189,  1726, 27,   4646, 1226, 5672, 3930, 4203, 5085, 3047, 7234, 1897, 876,  2417, 3334, 3808, 7763,
    7937, 2752, 987,  7101, 1311, 7832, 2719, 4486, 6291, 2849, 5229, 6643, 1356, 3128, 7153, 5607, 3143, 4336, 4466,
    756,  6904, 4093, 3596, 5446, 7958, 525,  1838, 6698, 3487, 1186, 4652, 5469, 626,  1257, 2059, 108,  2202, 4140,
    710,  496,  5181, 4161, 5800, 5309, 7168, 4054, 5237, 3971, 5549, 2131, 6839, 4721, 3457, 4764, 4937, 951,  1628,
    3194, 4010, 4603, 7659, 7688, 6073, 1526, 7456, 3276, 5291, 610,  6453, 2497, 558,  1032, 7920, 1390, 7990, 443,
    3990, 4522, 1470, 4411, 154,  5808, 3096, 4228, 383,  5631, 4545, 5017, 7998, 2089, 6981, 3562, 5316, 7340, 33,
    8077, 5728, 6920, 2585, 5750, 4683, 7252, 7542, 942,  88,   7860, 215,  6691, 6944, 2452, 3153, 293,  2513, 3270,
    2746, 7285, 2869, 793,  5155, 6830, 313,  54,   1101, 6899, 5667, 378,  3452, 8134, 2864, 2875, 6437, 6301, 77,
    2114, 4287, 4513, 2371, 905,  5204, 253,  1500, 2554, 5056, 7366, 1049, 7968, 2700, 324,  8139, 7884, 6777, 4674,
    636,  3533, 1705, 3160, 1605, 5971, 5678, 5710, 3514, 6220, 1771, 1916, 3893, 5358, 2988, 99,   5006, 7057, 4841,
    3589, 3085, 3057, 6770, 3295, 4043, 3612, 2017, 4875, 6442, 7412, 4917, 7144, 7090, 1652, 1204, 6319, 6505, 3750,
    6056, 2629, 4325, 7291, 6955, 1156, 7947, 7065, 4786, 18,   972,  3077, 7601, 6755, 2685, 6726, 3767, 7868, 7560,
    7816, 1736, 2343, 2880, 6523, 6866, 3038, 5782, 5906, 913,  3831, 5244, 2524, 1232, 4376, 1073, 4304, 7210, 3228,
    2912, 4248, 3661, 6343, 8185, 6683, 1511, 819,  7466, 6676, 7853, 5950, 480,  5175, 3022, 5000, 82,   4495, 8179,
    1965, 6197, 4109, 2323, 3916, 5455, 1376, 4589, 2382, 6564, 5161, 7515, 5344, 279,  1638, 6741, 1429, 6255, 4279,
    5094, 4576, 4987, 6242, 1330, 5191, 5697, 5654, 780,  4904, 6306, 1060, 3064, 7481, 3430, 1543, 5559, 2459, 8150,
    7317, 4209, 1884, 176,  1343, 4127, 7529, 430,  5536, 3181, 2808, 4501, 3525, 1759, 7930, 366,  6557, 2857, 4354,
    4863, 2159, 6044, 1122, 4292, 3709, 960,  6578, 574,  8034, 4622, 505,  3697, 5107, 3685, 6018, 3904, 799,  8167,
    834,  4267, 1809, 164,  6268, 5073, 1041, 4634, 6402, 3116, 2396, 2190, 6379, 5738, 4169, 1458, 1586, 2119, 7631,
    1616, 5419, 1398, 8008, 3782, 647,  4061, 7576, 3936, 586,  5026, 1689, 1442, 6540, 5492, 7744, 5269, 10,   6203,
    487,  931,  7474, 4667, 5439, 6426, 1520, 7757, 2892, 5960, 6012, 2376, 2623, 8128, 6353, 6878, 5282, 2332, 4223,
    4716, 751,  1221, 2338, 4870, 319,  7280, 1581, 1117, 4899, 4995, 7202, 668,  7331, 6007, 5505, 5568, 1975, 1748,
    1182, 3124, 3330, 7620, 7336, 4518, 7684, 4050, 5967, 2550, 374,  2448, 2520, 6722, 3746, 3053, 7313, 6238, 1372,
    6672, 7572, 2392, 5103, 6553, 3742, 1971, 747,  5435, 773,  2693, 4459, 4455, 5039, 3791, 7491, 7613, 673,  5209,
    2473, 1300, 984,  1894, 4643, 599,  2056, 1835, 4463, 5226, 5288, 4007, 6836, 5797, 2582, 6978, 3093, 7987, 6434,
    1098, 2743, 212,  1768, 1702, 2697, 5201, 6952, 1201, 2014, 4838, 7207, 910,  1733, 7598, 7512, 2320, 3019, 1508,
    4124, 5556, 777,  5091, 8164, 4619, 6041, 1756, 1439, 3779, 1455, 4631, 7277, 2329, 5957, 928,  6669, 2445, 7617,
    6004, 5794, 596,  7610, 5432, 1753, 1505, 4835, 209,  1411, 922,  5429, 925,  5934, 7128, 7495, 1016, 6884, 4361,
    1107, 1414, 6628, 3956, 6109, 7186, 3444, 7675, 2572, 1019, 6278, 1244, 3795, 1213, 3316, 1567, 4445, 7498, 1980,
    258,  6095, 3302, 2899, 6713, 2004, 7131, 300,  3257, 5043, 1903, 4974, 5523, 2310, 5937, 4850, 8021, 5256, 6389,
    6212, 4115, 6470, 1417, 272,  70,   1304, 1364, 2818, 3673, 3949, 1110, 5573, 5061, 2277, 1677, 224,  7589, 2924,
    4364, 3854, 6493, 2477, 7400, 6359, 5143, 60,   6887, 3393, 3502, 2934, 893,  2363, 738,  6659, 7189, 1085, 6028,
    5213, 660,  6480, 2264, 7176, 6112, 5510, 2559, 196,  5921, 2657, 3998, 1994, 3959, 5838, 3978, 677,  7240, 6125,
    698,  1557, 6631, 4074, 1714, 6588, 7222, 1876, 5461, 3029, 1022, 827,  1149, 603,  4966, 5625, 4087, 3386, 2575,
    7625, 1054, 6517, 7878, 190,  6089, 1727, 7678, 28,   6068, 4647, 3803, 1227, 6051, 5673, 3447, 3931, 3680, 4204,
    4584, 5086, 5221, 3048, 1216, 7235, 7395, 1898, 1011, 877,  6410, 2418, 3798, 3335, 7371, 3809, 2024, 7764, 7720,
    7938, 1247, 2753, 2035, 988,  2423, 7102, 4386, 1312, 6281, 7833, 6802, 2720, 6601, 4487, 3922, 6292, 7501, 2850,
    6763, 5230, 4827, 6644, 4820, 1357, 4448, 3129, 2705, 7154, 6967, 5608, 4957, 3144, 1570, 4337, 2639, 4467, 6415,
    757,  6612, 6905, 3319, 4094, 7729, 3597, 2539, 5447, 2409, 7959, 3305, 526,  6138, 1839, 7120, 6699, 5990, 3488,
    6098, 1187, 7973, 4653, 2434, 5470, 7711, 627,  261,  1258, 6846, 2060, 882,  109,  4798, 2203, 1983, 4141, 3634,
    711,  2253, 497,  4595, 5182, 7134, 4162, 7809, 5801, 3846, 5310, 3481, 7169, 2007, 4055, 8144, 5238, 1599, 3972,
    3251, 5550, 6716, 2132, 1847, 6840, 2029, 4722, 2166, 3458, 2902, 4765, 2825, 4938, 6178, 952,  4929, 1629, 1906,
    3195, 344,  4011, 1669, 4604, 4701, 7660, 5046, 7689, 329,  6074, 3619, 1527, 7800, 7457, 3260, 3277, 1853, 5292,
    3814, 611,  7644, 6454, 303,  2498, 2670, 559,  415,  1033, 1382, 7921, 5940, 1391, 5775, 7991, 6651, 444,  7704,
    3991, 2313, 4523, 6782, 1471, 4019, 4412, 5851, 155,  5526, 5809, 4182, 3097, 7376, 4229, 540,  384,  4977, 5632,
    2951, 4546, 5860, 5018, 5720, 7999, 6392, 2090, 7020, 6982, 690,  3563, 460,  5317, 5259, 7341, 7889, 34,   6152,
    8078, 451,  5729, 8024, 6921, 2138, 2586, 3340, 5751, 6990, 4684, 4853, 7253, 5888, 7543, 7439, 943,  6570, 89,
    1420, 7861, 6372, 216,  4404, 6692, 3556, 6945, 6473, 2453, 641,  3154, 3825, 294,  5832, 2514, 4118, 3271, 6915,
    2747, 1252, 7286, 4299, 2870, 6215, 794,  1684, 5156, 1338, 6831, 6036, 314,  1367, 55,   1552, 1102, 2305, 6900,
    2198, 5668, 1307, 379,  4679, 3453, 6449, 8135, 3889, 2865, 73,   2876, 2908, 6438, 7943, 6302, 426,  78,   275,
    2115, 5488, 4288, 4263, 4514, 2388, 2372, 1113, 906,  3775, 5205, 6974, 254,  8017, 1501, 3952, 2555, 1710, 5057,
    3498, 7367, 6798, 1050, 3676, 7969, 3630, 2701, 7725, 325,  2666, 8140, 2821, 7885, 5884, 6778, 2947, 4675, 5484,
    637,  1680, 3534, 5392, 1706, 5880, 3161, 3406, 1606, 2280, 5972, 3538, 5679, 233,  5711, 4026, 3515, 5064, 6221,
    3464, 1772, 7769, 1917, 2213, 3894, 5576, 5359, 5396, 2989, 8043, 100,  7521, 5007, 4367, 7058, 1802, 4842, 2490,
    3590, 4539, 3086, 2927, 3058, 1610, 6771, 6860, 3296, 5915, 4044, 7592, 3613, 6146, 2018, 2428, 4876, 1129, 6443,
    227,  7413, 2284, 4918, 8109, 7145, 1322, 7091, 7403, 1653, 2237, 1205, 1661, 6320, 3210, 6506, 2480, 3751, 3165,
    6057, 4882, 2630, 3867, 4326, 6496, 7292, 2172, 6956, 993,  1157, 1272, 7948, 3857, 7066, 3410, 4787, 132,  19,
    5167, 973,  6890, 3078, 359,  7602, 7161, 6756, 5768, 2686, 63,   6727, 5683, 3768, 352,  7869, 7042, 7561, 5146,
    7817, 2074, 1737, 2040, 2344, 3722, 2881, 6362, 6524, 237,  6867, 860,  3039, 6189, 5783, 896,  5907, 5129, 914,
    3243, 3832, 7786, 5245, 2937, 2525, 5976, 1233, 1135, 4377, 1478, 1074, 3505, 4305, 4728, 7211, 2758, 3229, 7028,
    2913, 3396, 4249, 3542, 3662, 5378, 6344, 285,  8186, 7192, 6684, 812,  1512, 5617, 820,  4155, 7467, 6662, 6677,
    3519, 7854, 7051, 5951, 6464, 481,  741,  5176, 7915, 3023, 6286, 5001, 967,  83,   2366, 4496, 5068, 8180, 6250,
    1966, 1093, 6198, 663,  4110, 733,  2324, 7670, 3917, 2404, 5456, 5216, 1377, 5715, 4590, 4924, 2383, 5479, 6565,
    6031, 5162, 6184, 7516, 1317, 5345, 1487, 280,  1088, 1639, 4030, 6742, 3648, 1430, 5350, 6256, 6115, 4280, 6734,
    5095, 2712, 4577, 6171, 4988, 7179, 6243, 1776, 1331, 8102, 5192, 5871, 5698, 2267, 5655, 3876, 781,  4391, 4905,
    1789, 6307, 6483, 1061, 7773, 3065, 847,  7482, 1492, 3431, 5924, 1544, 725,  5560, 7387, 2460, 1822, 8151, 199,
    7318, 6225, 4210, 8115, 1885, 6789, 177,  2562, 1344, 4944, 4128, 7107, 7530, 7007, 431,  5513, 5537, 3468, 3182,
    402,  2809, 6747, 4502, 3962, 3526, 1536, 1760, 518,  7931, 7450, 367,  1997, 6558, 3898, 2858, 4319, 4355, 5137,
    4864, 4001, 2160, 534,  6045, 6606, 1123, 3716, 4293, 2660, 3710, 5580, 961,  1783, 6579, 3653, 575,  7243, 8035,
    394,  4623, 2245, 506,  3000, 3698, 680,  5108, 1921, 3686, 7419, 6019, 5120, 3905, 3981, 800,  2831, 8168, 2725,
    835,  4742, 4268, 5841, 1810, 2217, 165,  3351, 6269, 1644, 5074, 6634, 1042, 5690, 4635, 3136, 6403, 4694, 3117,
    1560, 2397, 2993, 2191, 3203, 6380, 123,  5739, 701,  4170, 2772, 1459, 6807, 1587, 5586, 2120, 6128, 7632, 8047,
    1617, 4421, 5420, 4035, 1399, 7225, 8009, 6163, 3783, 4812, 648,  8087, 4062, 6591, 7577, 5363, 3937, 2290, 587,
    4530, 5027, 1717, 1690, 4771, 1443, 7838, 6541, 2098, 5493, 4077, 7745, 5400, 5270, 5327, 11,   6261, 6204, 1025,
    488,  2800, 932,  6334, 7475, 5413, 4668, 3032, 5440, 5011, 6427, 2356, 1521, 8072, 7758, 5464, 2893, 2651, 5961,
    7506, 6013, 581,  2377, 1879, 2624, 4371, 8129, 5705, 6354, 6120, 6879, 4969, 5283, 8159, 2333, 7308, 4224, 5746,
    4717, 606,  752,  104,  1222, 7097, 2339, 3224, 4871, 1152, 320,  1912, 7281, 6297, 1582, 6536, 1118, 830,  4900,
    7525, 4996, 5340, 7203, 1435, 669,  2578, 7332, 7568, 6008, 1577, 5506, 4070, 5569, 3389, 1976, 4846, 1749, 6624,
    1183, 4137, 3125, 4090, 3331, 7829, 7621, 3927, 7337, 7249, 4519, 5628, 7685, 2494, 4051, 4761, 5968, 5355, 2551,
    7881, 375,  2111, 2449, 790,  2521, 4245, 6723, 6520, 3747, 7062, 3054, 7409, 7314, 5533, 6239, 1057, 1373, 1635,
    6673, 4492, 7573, 7741, 2393, 7628, 5104, 1806, 6554, 3706, 3743, 5100, 1972, 7681, 748,  4896, 5436, 2620, 774,
    1452, 2694, 1730, 4460, 3090, 4456, 2470, 5040, 5253, 3792, 6092, 7492, 6106, 7614, 4832, 674,  6585, 5210, 193,
    2474, 2931, 1301, 2274, 985,  2717, 1895, 3806, 4644, 4201, 600,  6514, 2057, 708,  1836, 4650, 4464, 3594, 5227,
    7151, 5289, 556,  4008, 6071, 6837, 4935, 5798, 5235, 2583, 7540, 6979, 31,   3094, 4543, 7988, 1468, 6435, 4285,
    1099, 3450, 2744, 5153, 213,  3151, 1769, 2986, 1703, 5676, 2698, 6775, 5202, 5054, 6953, 4784, 1202, 6054, 2015,
    4915, 4839, 6768, 7208, 3659, 911,  1230, 1734, 6864, 7599, 3765, 7513, 6739, 2321, 4587, 3020, 8177, 1509, 7851,
    4125, 3179, 5557, 4207, 778,  3062, 5092, 1328, 8165, 162,  4620, 3683, 6042, 958,  1757, 2855, 1440, 5267, 3780,
    3934, 1456, 1614, 4632, 2188, 7278, 4993, 2330, 1219, 5958, 8126, 929,  6424, 6670, 6551, 2446, 3051, 7618, 4048,
    6005, 1746, 5795, 7985, 597,  5224, 7611, 1298, 5433, 4453, 1754, 4629, 1506, 5089, 4836, 7596, 210,  5199, 1412,
    7184, 923,  1014, 5430, 207,  926,  6002, 5935, 6387, 7129, 1901, 7496, 3300, 1017, 1211, 6885, 891,  4362, 7398,
    1108, 1675, 1415, 1362, 6629, 7220, 3957, 7238, 6110, 5919, 7187, 658,  3445, 4582, 7676, 3801, 2573, 7876, 1020,
    4964, 6279, 6599, 1245, 2421, 3796, 2022, 1214, 1009, 3317, 2537, 1568, 6413, 4446, 6965, 7499, 4825, 1981, 2251,
    259,  880,  6096, 2432, 3303, 7118, 2900, 6176, 6714, 2027, 2005, 1597, 7132, 3844, 301,  413,  3258, 3812, 5044,
    3617, 1904, 1667, 4975, 5858, 5524, 7374, 2311, 4017, 5938, 6649, 4851, 7437, 8022, 3338, 5257, 6150, 6390, 688,
    6213, 1336, 4116, 1250, 6471, 3823, 1418, 4402, 273,  4261, 71,   7941, 1305, 6447, 1365, 2303, 2819, 2945, 3674,
    7723, 3950, 3496, 1111, 6972, 5574, 8041, 5062, 7767, 2278, 231,  1678, 5878, 225,  8107, 7590, 2426, 2925, 6858,
    4365, 2488, 3855, 130,  6494, 991,  2478, 4880, 7401, 1659, 6360, 858,  5144, 2038, 61,   350,  6888, 7159, 3394,
    5376, 3503, 2756, 2935, 1133, 894,  3241, 2364, 6248, 739,  6284, 6660, 7049, 7190, 5615, 1086, 3646, 6029, 1315,
    5214, 4922, 661,  7668, 6481, 845,  2265, 4389, 7177, 8100, 6113, 2710, 5511, 400,  2560, 7105, 197,  8113, 5922,
    7385, 2658, 1781, 3999, 6604, 1995, 4317, 3960, 516,  5839, 3349, 3979, 2723, 678,  7417, 7241, 2243, 6126, 4419,
    699,  6805, 1558, 3201, 6632, 3134, 4075, 5325, 1715, 7836, 6589, 2288, 7223, 4810, 1877, 5703, 5462, 7504, 3030,
    2354, 1023, 6332, 828,  5338, 1150, 6295, 604,  7095, 4967, 7306, 5626, 4759, 4088, 3925, 3387, 6622, 2576, 1575,
    7626, 3704, 1055, 4490, 6518, 7407, 7879, 788,  191,  2272, 6090, 4830, 1728, 2468, 7679, 2618, 29,   1466, 6069,
    5233, 4648, 7149, 3804, 6512, 1228, 3763, 6052, 6766, 5674, 5052, 3448, 3149, 3932, 2186, 3681, 2853, 4205, 1326,
    4585, 7849, 5087, 5197, 5222, 4451, 3049, 1744, 1217, 6422, 7236, 656,  7396, 1360, 1899, 1209, 1012, 6000, 878,
    7116, 6411, 4823, 2419, 1007, 3799, 4962, 3336, 686,  7372, 6647, 3810, 1665, 2025, 3842, 7765, 5876, 7721, 6970,
    7939, 2301, 1248, 4400, 2754, 3239, 2036, 7157, 989,  1657, 2424, 2486, 7103, 7383, 4387, 2708, 1313, 7666, 6282,
    5613, 7834, 4808, 6803, 3132, 2721, 2241, 6602, 514,  4488, 786,  3923, 1573, 6293, 7304, 7502, 6330, 2851, 7847,
    6764, 3147, 5231, 6510, 4828, 2616, 6645, 3840, 4821, 4960, 1358, 5998, 4449, 6420, 3130, 512,  2706, 5611, 7155,
    2484, 6968, 4398, 5609, 4396, 4958, 6418, 3145, 2614, 1571, 6328, 4338, 6814, 2640, 4470, 4468, 6324, 6416, 6326,
    758,  1167, 6613, 2642, 6906, 4707, 3320, 4472, 4095, 4562, 7730, 4340, 3598, 3214, 2540, 6816, 5448, 5660, 2410,
    3322, 7960, 2047, 3306, 4474, 527,  7908, 6139, 6908, 1840, 6061, 7121, 4709, 6700, 4432, 5991, 6615, 3489, 1291,
    6099, 2644, 1188, 3006, 7974, 760,  4654, 4886, 2435, 1169, 5471, 3881, 7712, 2542, 628,  2734, 262,  6818, 1259,
    7078, 6847, 3600, 2061, 3755, 883,  3216, 110,  3104, 4799, 7732, 2204, 4610, 1984, 4342, 4142, 468,  3635, 4097,
    712,  3169, 2254, 4564, 498,  6312, 4596, 3308, 5183, 5599, 7135, 4476, 4163, 5648, 7810, 7962, 5802, 4330, 3847,
    2049, 5311, 7654, 3482, 2412, 7170, 4439, 2008, 3324, 4056, 3692, 8145, 5450, 5239, 6500, 1600, 5662, 3973, 6488,
    3252, 7123, 5551, 1830, 6717, 4711, 2133, 4177, 1848, 1842, 6841, 2634, 2030, 6063, 4723, 2069, 2167, 6141, 3459,
    3625, 2903, 6910, 4766, 2767, 2826, 529,  4939, 3871, 6179, 7910, 953,  4910, 4930, 6101, 1630, 7824, 1907, 2646,
    3196, 8095, 345,  3491, 4012, 6960, 1670, 1293, 4605, 1286, 4702, 5993, 7661, 1002, 5047, 6617, 7690, 7425, 330,
    6702, 6075, 997,  3620, 4434, 1528, 1794, 7801, 2437, 7458, 3377, 3261, 1171, 3278, 8060, 1854, 4656, 5293, 7296,
    3815, 4888, 612,  4189, 7645, 7976, 6455, 6080, 304,  762,  2499, 2974, 2671, 1190, 560,  2176, 416,  3008, 1034,
    3070, 1383, 264,  7922, 5301, 5941, 6820, 1392, 3424, 5776, 630,  7992, 7952, 6652, 2736, 445,  7794, 7705, 7714,
    3992, 6707, 2314, 2544, 4524, 5114, 6783, 5473, 1472, 3861, 4020, 3883, 4413, 852,  5852, 885,  156,  550,  5527,
    3218, 5810, 2779, 4183, 2063, 3098, 1161, 7377, 3757, 4230, 2785, 541,  6849, 385,  335,  4978, 3602, 5633, 3362,
    2952, 1261, 4547, 1276, 5861, 7080, 5019, 1066, 5721, 1986, 8000, 2081, 6393, 4344, 2091, 7000, 7021, 2206, 6983,
    4791, 691,  4612, 3564, 2967, 461,  4801, 5318, 7430, 5260, 7734, 7342, 1927, 7890, 112,  35,   136,  6153, 3106,
    8079, 7778, 452,  2256, 5730, 146,  8025, 4566, 6922, 2595, 2139, 714,  2587, 7070, 3341, 3171, 5752, 5816, 6991,
    3637, 4685, 7695, 4854, 4099, 7254, 3571, 5889, 4144, 7544, 3414, 7440, 470,  944,  3436, 6571, 7137, 90,   1865,
    1421, 4478, 7862, 7360, 6373, 5185, 217,  977,  4405, 5601, 6693, 871,  3557, 4598, 6946, 1176, 6474, 3310, 2454,
    3911, 642,  500,  3155, 6894, 3826, 6314, 295,  5929, 5833, 3849, 2515, 4218, 4119, 2051, 3272, 2127, 6916, 5804,
    2748, 23,   1253, 4332, 7287, 3608, 4300, 7812, 2871, 3266, 6216, 7964, 795,  2155, 1685, 4165, 5157, 5171, 1339,
    5650, 6832, 7487, 6037, 2010, 315,  2888, 1368, 3326, 56,   3945, 1553, 7172, 1103, 7606, 2306, 4441, 6901, 1353,
    2199, 3484, 5669, 3382, 1308, 2414, 380,  3987, 4680, 5313, 3454, 7165, 6450, 7656, 8136, 1497, 3890, 1602, 2866,
    6941, 74,   5664, 2877, 2682, 2909, 5241, 6439, 3082, 7944, 6502, 6303, 4984, 427,  8147, 79,   7463, 276,  5452,
    2116, 3113, 5489, 4058, 4289, 363,  4264, 3694, 4515, 5565, 2389, 6719, 2373, 4664, 1114, 4713, 907,  1699, 3776,
    5553, 5206, 2690, 6975, 1832, 255,  1241, 8018, 3254, 1502, 2442, 3953, 7125, 2556, 6025, 1711, 3975, 5058, 67,
    3499, 6490, 7368, 7392, 6799, 2032, 1051, 1146, 3677, 6065, 7970, 6135, 3631, 6843, 2702, 6760, 7726, 2636, 326,
    341,  2667, 1850, 8141, 7806, 2822, 1844, 7886, 7017, 5885, 2135, 6779, 5772, 2948, 4179, 4676, 1549, 5485, 2905,
    638,  6369, 1681, 6912, 3535, 5389, 5393, 3461, 1707, 3772, 5881, 3627, 3162, 2234, 3407, 2169, 1607, 1799, 2281,
    6143, 5973, 5126, 3539, 4725, 5680, 356,  234,  2071, 5712, 730,  4027, 6181, 3516, 809,  5065, 7912, 6222, 722,
    3465, 4941, 1773, 6731, 7770, 3873, 1918, 391,  2214, 2828, 3895, 1533, 5577, 531,  5360, 6160, 5397, 4768, 2990,
    5687, 8044, 2769, 101,  8156, 7522, 1909, 5008, 2797, 4368, 2648, 7059, 2108, 1803, 1632, 4843, 7565, 2491, 7826,
    3591, 4198, 4540, 4932, 3087, 4893, 2928, 6103, 3059, 8174, 1611, 955,  6772, 5150, 6861, 4912, 3297, 204,  5916,
    1672, 4045, 8123, 7593, 1295, 3614, 1594, 6147, 4014, 2019, 7873, 2429, 6962, 4877, 6855, 1130, 347,  6444, 3820,
    228,  3493, 7414, 4314, 2285, 3198, 4919, 7046, 8110, 8097, 7146, 2465, 1323, 5049, 7092, 2351, 7404, 6619, 1654,
    2298, 2238, 7663, 1206, 1741, 1662, 1004, 6321, 2611, 3211, 4704, 6507, 7301, 2481, 5995, 3752, 2731, 3166, 4607,
    6058, 2044, 4883, 1288, 2631, 1827, 3868, 3622, 4327, 5596, 6497, 4436, 7293, 3374, 2173, 6077, 6957, 7821, 994,
    999,  1158, 547,  1273, 332,  7949, 5298, 3858, 6704, 7067, 143,  3411, 7692, 4788, 2078, 133,  7427, 20,   4215,
    5168, 3263, 974,  1862, 6891, 1173, 3079, 6938, 360,  7460, 7603, 2885, 7162, 3379, 6757, 1143, 5769, 7803, 2687,
    4661, 64,   2439, 6728, 806,  5684, 1530, 3769, 6366, 353,  1796, 7870, 8120, 7043, 3817, 7562, 2794, 5147, 4890,
    7818, 5593, 2075, 5295, 1738, 2348, 2041, 7298, 2345, 2791, 3723, 1856, 2882, 1859, 6363, 4658, 6525, 1950, 238,
    3280, 6868, 3726, 861,  8062, 3040, 7323, 6190, 306,  5784, 3729, 897,  764,  5908, 5825, 5130, 6457, 915,  6871,
    3244, 6082, 3833, 4752, 7787, 7647, 5246, 8065, 2938, 7978, 2526, 2837, 5977, 614,  1234, 864,  1136, 4191, 4378,
    6230, 1479, 418,  1075, 1953, 3506, 3010, 4306, 2147, 4729, 562,  7212, 6528, 2759, 2178, 3230, 4236, 7029, 2673,
    2914, 3283, 3397, 1192, 4250, 42,   3543, 2501, 3663, 241,  5379, 2976, 6345, 182,  286,  5943, 8187, 3732, 7193,
    6822, 6685, 3583, 813,  7924, 1513, 5787, 5618, 5303, 821,  2844, 4156, 1385, 7468, 767,  6663, 266,  6678, 4274,
    3520, 1036, 7855, 900,  7052, 3072, 5952, 2567, 6465, 6654, 482,  7326, 742,  2738, 5177, 1624, 7916, 7994, 3024,
    3043, 6287, 7954, 5002, 7086, 968,  5778, 84,   309,  2367, 632,  4497, 570,  5069, 1394, 8181, 6193, 6251, 3426,
    1967, 1890, 1094, 2316, 6199, 6874, 664,  2546, 4111, 7585, 734,  3994, 2325, 918,  7671, 6709, 3918, 4953, 2405,
    7707, 5457, 6085, 5217, 7716, 1378, 5847, 5716, 447,  4591, 3247, 4925, 7796, 2384, 6794, 5480, 4022, 6566, 5828,
    6032, 3885, 5163, 7038, 6185, 1474, 7517, 5911, 1318, 3863, 5346, 5867, 1488, 6785, 281,  6460, 1089, 5475, 1640,
    119,  4031, 4526, 6743, 5133, 3649, 5116, 1431, 4133, 5351, 5529, 6257, 8068, 6116, 3220, 4281, 4780, 6735, 158,
    5096, 5249, 2713, 552,  4578, 2533, 6172, 5854, 4989, 7981, 7180, 887,  6244, 841,  1777, 4415, 1332, 2941, 8103,
    854,  5193, 7112, 5872, 7379, 5699, 4755, 2268, 3759, 5656, 4428, 3877, 3100, 782,  3836, 4392, 1163, 4906, 1282,
    1790, 4185, 6308, 7650, 6484, 2065, 1062, 2963, 7774, 5812, 3066, 7790, 848,  2781, 7483, 1349, 1493, 4980, 3432,
    867,  5925, 3604, 1545, 2230, 726,  387,  5561, 1237, 7388, 337,  2461, 2607, 1823, 543,  8152, 4194, 200,  6851,
    7319, 4748, 6226, 4232, 4211, 1139, 8116, 2787, 1886, 4949, 6790, 5863, 178,  2840, 2563, 7082, 1345, 2603, 4945,
    4549, 4129, 2529, 7108, 1278, 7531, 4553, 7008, 2954, 432,  617,  5514, 1263, 5538, 7897, 3469, 5635, 3183, 5980,
    403,  3364, 2810, 436,  6748, 6395, 4503, 1956, 3963, 4346, 3527, 5900, 1537, 8002, 1761, 1078, 519,  2083, 7932,
    621,  7451, 5723, 368,  3013, 1998, 1988, 6559, 171,  3899, 5021, 2859, 3509, 4320, 1068, 4356, 5518, 5138, 693,
    4865, 6233, 4002, 4614, 2161, 7639, 535,  6985, 6046, 4381, 6607, 4793, 1124, 1267, 3717, 7023, 4294, 421,  2661,
    2208, 3711, 4737, 5581, 2093, 962,  1482, 1784, 7002, 6580, 7535, 3654, 5262, 576,  6531, 7244, 7736, 8036, 5371,
    395,  5320, 4624, 7215, 2246, 7432, 507,  4557, 3001, 463,  3699, 2181, 681,  4803, 5109, 3357, 1922, 3566, 3687,
    2762, 7420, 2969, 6020, 7012, 5121, 6155, 3906, 2150, 3982, 3108, 801,  1945, 2832, 37,   8169, 4309, 2726, 138,
    836,  2958, 4743, 7892, 4269, 565,  5842, 114,  1811, 1934, 2218, 7344, 166,  4732, 3352, 1929, 6270, 3187, 1645,
    8027, 5075, 3286, 6635, 4568, 1043, 7554, 5691, 5732, 4636, 2917, 3137, 148,  6404, 5984, 4695, 454,  3118, 1195,
    1561, 2258, 2398, 1816, 2994, 8081, 2192, 3400, 3204, 7780, 6381, 407,  124,  3343, 5740, 4239, 702,  3173, 4171,
    8054, 2773, 2589, 1460, 3233, 6808, 7072, 1588, 3368, 5587, 2141, 2121, 2676, 6129, 716,  7633, 1939, 8048, 6924,
    1618, 7032, 4422, 2597, 5421, 5542, 4036, 4856, 1400, 244,  7226, 4101, 8010, 5761, 6164, 4687, 3784, 3666, 4813,
    7697, 649,  7901, 8088, 6993, 4063, 2979, 6592, 3639, 7578, 2223, 5364, 5754, 3938, 5382, 2291, 5818, 588,  3473,
    4531, 7442, 5028, 45,   1718, 472,  1691, 6930, 4772, 7546, 1444, 4253, 7839, 3416, 6542, 5639, 2099, 5891, 5494,
    2504, 4078, 4146, 7746, 7349, 5401, 7256, 5271, 3546, 5328, 3573, 12,   4507, 6262, 1423, 6205, 3735, 1026, 4480,
    489,  7269, 2801, 92,   933,  8190, 6335, 1867, 7476, 1960, 5414, 6573, 4669, 6825, 3033, 7139, 5441, 5080, 5012,
    946,  6428, 7196, 2357, 3438, 1522, 3967, 8073, 4407, 7759, 185,  5465, 5603, 2894, 1406, 2652, 219,  5962, 6348,
    7507, 979,  6014, 4350, 582,  6375, 2378, 5946, 1880, 5187, 2625, 3291, 4372, 7864, 8130, 289,  5706, 7362, 6355,
    2814, 6121, 6476, 6880, 5790, 4970, 3312, 5284, 5035, 8160, 6948, 2334, 1516, 7309, 1178, 4225, 440,  5747, 3559,
    4718, 5306, 607,  4600, 753,  6640, 105,  6695, 1223, 5621, 7098, 873,  2340, 6752, 3225, 3828, 4872, 3586, 1153,
    6316, 321,  250,  1913, 3157, 7282, 6688, 6298, 6896, 1583, 6399, 6537, 644,  1119, 7927, 831,  502,  4901, 4573,
    7526, 2456, 4997, 816,  5341, 3913, 7204, 1765, 1436, 4121, 670,  770,  2579, 2053, 7333, 5502, 7569, 2517, 6009,
    7471, 1578, 4220, 5507, 1082, 4071, 5835, 5570, 269,  3390, 3851, 1977, 6275, 4847, 297,  1750, 6666, 6625, 5931,
    1184, 523,  4138, 1255, 3126, 2847, 4091, 4334, 3332, 7232, 7830, 2750, 7622, 824,  3928, 25,   7338, 2087, 7250,
    6918, 4520, 1388, 5629, 5806, 7686, 3192, 2495, 3274, 4052, 4159, 4762, 2129, 5969, 3531, 5356, 6218, 2552, 903,
    7882, 7966, 376,  52,   2112, 2873, 2450, 7858, 791,  3268, 2522, 5904, 4246, 4302, 6724, 3075, 6521, 7814, 3748,
    1650, 7063, 7289, 3055, 7055, 7410, 3610, 7315, 1541, 5534, 1341, 6240, 4277, 1058, 5652, 1374, 4107, 1636, 5159,
    6674, 6681, 4493, 5173, 7574, 8006, 7742, 1687, 2394, 1039, 7629, 4167, 5105, 8032, 1807, 797,  6555, 3523, 3707,
    2157, 3744, 372,  5101, 1370, 1973, 7329, 7682, 3328, 749,  5280, 4897, 317,  5437, 485,  2621, 2890, 775,  3017,
    1453, 6039, 2695, 2741, 1731, 2012, 4461, 4641, 3091, 6834, 4457, 745,  2471, 7489, 5041, 2002, 5254, 2308, 3793,
    2570, 6093, 4443, 7493, 5427, 6107, 1105, 7615, 5955, 4833, 7608, 675,  1992, 6586, 1555, 5211, 6657, 194,  7174,
    2475, 2922, 2932, 58,   1302, 6468, 2275, 3947, 986,  7936, 2718, 1310, 1896, 3046, 3807, 2416, 4645, 1725, 4202,
    5671, 601,  3027, 6515, 3384, 2058, 625,  709,  2201, 1837, 7957, 4651, 3486, 4465, 3142, 3595, 6903, 5228, 6290,
    7152, 1355, 5290, 7455, 557,  6452, 4009, 1627, 6072, 7658, 6838, 5548, 4936, 3456, 5799, 5180, 5236, 7167, 2584,
    5727, 7541, 4682, 6980, 7997, 32,   5315, 3095, 153,  4544, 382,  7989, 7919, 1469, 3989, 6436, 2863, 4286, 76,
    1100, 312,  3451, 5666, 2745, 2512, 5154, 2868, 214,  87,   3152, 6943, 1770, 3513, 2987, 3892, 1704, 635,  5677,
    1604, 2699, 1048, 6776, 8138, 5203, 2370, 5055, 1499, 6954, 4324, 4785, 7946, 1203, 7089, 6055, 6504, 2016, 4042,
    4916, 6441, 4840, 5005, 6769, 3084, 7209, 1072, 3660, 2911, 912,  5781, 1231, 5243, 1735, 7559, 6865, 2879, 7600,
    971,  3766, 2684, 7514, 6563, 6740, 278,  2322, 6196, 4588, 5454, 3021, 479,  8178, 81,   1510, 8184, 7852, 7465,
    4126, 175,  3180, 429,  5558, 3429, 4208, 8149, 779,  5696, 3063, 6305, 5093, 6254, 1329, 4986, 8166, 3903, 163,
    4266, 4621, 573,  3684, 3696, 6043, 4862, 959,  4291, 1758, 4500, 2856, 365,  1441, 5025, 5268, 5491, 3781, 1397,
    3935, 4060, 1457, 5737, 1615, 2118, 4633, 5072, 2189, 3115, 7279, 4869, 4994, 1116, 2331, 6877, 1220, 4715, 5959,
    7756, 8127, 2375, 930,  6202, 6425, 4666, 6671, 6237, 6552, 2391, 2447, 2549, 3052, 6721, 7619, 3123, 4049, 4517,
    6006, 667,  1747, 5567, 5796, 4006, 7986, 6977, 598,  1893, 5225, 1834, 7612, 3790, 1299, 5208, 5434, 1970, 4454,
    2692, 1755, 4618, 4630, 3778, 1507, 2319, 5090, 5555, 4837, 1200, 7597, 909,  211,  1097, 5200, 1701, 1413, 4360,
    7185, 3955, 924,  921,  1015, 7127, 5431, 595,  208,  1504, 927,  2328, 6003, 2444, 5936, 5522, 6388, 8020, 7130,
    6712, 1902, 3256, 7497, 1566, 3301, 257,  1018, 7674, 1212, 1243, 6886, 5142, 892,  3501, 4363, 7588, 7399, 6492,
    1109, 3672, 1676, 5060, 1416, 4114, 1363, 69,   6630, 697,  7221, 1713, 3958, 3997, 7239, 3977, 6111, 2263, 5920,
    2558, 7188, 737,  659,  6027, 3446, 6050, 4583, 3679, 7677, 6088, 3802, 6067, 2574, 4086, 7877, 1053, 1021, 5460,
    4965, 1148, 6280, 4385, 6600, 6801, 1246, 7719, 2422, 2034, 3797, 6409, 2023, 7370, 1215, 5220, 1010, 7394, 3318,
    6611, 2538, 7728, 1569, 4956, 6414, 2638, 4447, 4819, 6966, 2704, 7500, 3921, 4826, 6762, 1982, 4797, 2252, 3633,
    260,  7710, 881,  6845, 6097, 5989, 2433, 7972, 3304, 2408, 7119, 6137, 2901, 2165, 6177, 2824, 6715, 3250, 2028,
    1846, 2006, 3480, 1598, 8143, 7133, 4594, 3845, 7808, 302,  7643, 414,  2669, 3259, 7799, 3813, 1852, 5045, 4700,
    3618, 328,  1905, 4928, 1668, 343,  4976, 539,  5859, 2950, 5525, 5850, 7375, 4181, 2312, 7703, 4018, 6781, 5939,
    1381, 6650, 5774, 4852, 6989, 7438, 5887, 8023, 450,  3339, 2137, 5258, 459,  6151, 7888, 6391, 5719, 689,  7019,
    6214, 4298, 1337, 1683, 4117, 5831, 1251, 6914, 6472, 3555, 3824, 640,  1419, 6569, 4403, 6371, 274,  425,  4262,
    5487, 72,   3888, 7942, 2907, 1306, 2197, 6448, 4678, 1366, 6035, 2304, 1551, 2820, 2665, 2946, 5883, 3675, 6797,
    7724, 3629, 3951, 8016, 3497, 1709, 1112, 2387, 6973, 3774, 5575, 2212, 8042, 5395, 5063, 4025, 7768, 3463, 2279,
    3405, 232,  3537, 1679, 5483, 5879, 5391, 226,  1128, 8108, 2283, 7591, 5914, 2427, 6145, 2926, 4538, 6859, 1609,
    4366, 7520, 2489, 1801, 3856, 1271, 131,  3409, 6495, 3866, 992,  2171, 2479, 3209, 4881, 3164, 7402, 1321, 1660,
    2236, 6361, 3721, 859,  236,  5145, 7041, 2039, 2073, 62,   5767, 351,  5682, 6889, 5166, 7160, 358,  3395, 7027,
    5377, 3541, 3504, 1477, 2757, 4727, 2936, 7785, 1134, 5975, 895,  6188, 3242, 5128, 2365, 966,  6249, 5067, 740,
    6463, 6285, 7914, 6661, 4154, 7050, 3518, 7191, 284,  5616, 811,  1087, 1486, 3647, 4029, 6030, 5478, 1316, 6183,
    5215, 2403, 4923, 5714, 662,  1092, 7669, 732,  6482, 1788, 846,  7772, 2266, 5870, 4390, 3875, 7178, 6170, 8101,
    1775, 6114, 5349, 2711, 6733, 5512, 7006, 401,  3467, 2561, 6788, 7106, 4943, 198,  1821, 8114, 6224, 5923, 1491,
    7386, 724,  2659, 3715, 1782, 5579, 4000, 5136, 6605, 533,  1996, 7449, 4318, 3897, 3961, 6746, 517,  1535, 5840,
    4741, 3350, 2216, 3980, 5119, 2724, 2830, 679,  2999, 7418, 1920, 7242, 3652, 2244, 393,  6127, 5585, 4420, 8046,
    700,  122,  6806, 2771, 1559, 4693, 3202, 2992, 6633, 1643, 3135, 5689, 4076, 2097, 5326, 5399, 1716, 4529, 7837,
    4770, 6590, 8086, 2289, 5362, 7224, 4034, 4811, 6162, 1878, 580,  5704, 4370, 5463, 8071, 7505, 2650, 3031, 5412,
    2355, 5010, 1024, 6260, 6333, 2799, 829,  6535, 5339, 7524, 1151, 3223, 6296, 1911, 605,  5745, 7096, 103,  4968,
    6119, 7307, 8158, 5627, 7248, 4760, 2493, 4089, 4136, 3926, 7828, 3388, 4069, 6623, 4845, 2577, 1434, 1576, 7567,
    7627, 7740, 3705, 1805, 1056, 5532, 4491, 1634, 6519, 4244, 7408, 7061, 7880, 5354, 789,  2110, 192,  6584, 2273,
    2930, 6091, 5252, 4831, 6105, 1729, 1451, 2469, 3089, 7680, 5099, 2619, 4895, 30,   7539, 1467, 4542, 6070, 555,
    5234, 4934, 4649, 707,  7150, 3593, 3805, 2716, 6513, 4200, 1229, 3658, 3764, 6863, 6053, 4783, 6767, 4914, 5675,
    2985, 5053, 6774, 3449, 4284, 3150, 5152, 3933, 5266, 2187, 1613, 3682, 161,  2854, 957,  4206, 3178, 1327, 3061,
    4586, 6738, 7850, 8176, 5088, 4628, 5198, 7595, 5223, 7984, 4452, 1297, 3050, 6550, 1745, 4047, 1218, 4992, 6423,
    8125, 7237, 7219, 657,  5918, 7397, 890,  1361, 1674, 1900, 6386, 1210, 3299, 1013, 7183, 6001, 206,  879,  2250,
    7117, 2431, 6412, 2536, 4824, 6964, 2420, 6598, 1008, 2021, 3800, 4581, 4963, 7875, 3337, 7436, 687,  6149, 7373,
    5857, 6648, 4016, 3811, 412,  1666, 3616, 2026, 6175, 3843, 1596, 7766, 8040, 5877, 230,  7722, 2944, 6971, 3495,
    7940, 4260, 2302, 6446, 1249, 1335, 4401, 3822, 2755, 5375, 3240, 1132, 2037, 857,  7158, 349,  990,  129,  1658,
    4879, 2425, 8106, 2487, 6857, 7104, 399,  7384, 8112, 4388, 844,  2709, 8099, 1314, 3645, 7667, 4921, 6283, 6247,
    5614, 7048, 7835, 5324, 4809, 2287, 6804, 4418, 3133, 3200, 2722, 3348, 2242, 7416, 6603, 1780, 515,  4316, 4489,
    3703, 787,  7406, 3924, 4758, 1574, 6621, 6294, 5337, 7305, 7094, 7503, 5702, 6331, 2353, 2852, 2185, 7848, 1325,
    6765, 3762, 3148, 5051, 5232, 1465, 6511, 7148, 4829, 2271, 2617, 2467, 6646, 685,  3841, 1664, 4822, 7115, 4961,
    1006, 1359, 655,  5999, 1208, 4450, 5196, 6421, 1743, 3131, 4807, 513,  2240, 2707, 7382, 5612, 7665, 7156, 3238,
    2485, 1656, 6969, 5875, 4399, 2300, 5610, 511,  4397, 2483, 4959, 3839, 6419, 5997, 3146, 7846, 2615, 6509, 1572,
    785,  6329, 7303, 4339, 4561, 6815, 3213, 2641, 1166, 4471, 4706, 4469, 6813, 6325, 6323, 6417, 4395, 6327, 2613,
    759,  3005, 1168, 4885, 6614, 4431, 2643, 1290, 6907, 7907, 4708, 6060, 3321, 5659, 4473, 2046, 4096, 467,  4563,
    3168, 7731, 3103, 4341, 4609, 3599, 7077, 3215, 3754, 2541, 3880, 6817, 2733, 5449, 3691, 5661, 6499, 2411, 7653,
    3323, 4438, 7961, 5647, 2048, 4329, 3307, 6311, 4475, 5598, 528,  2766, 7909, 3870, 6140, 2068, 6909, 3624, 1841,
    4176, 6062, 2633, 7122, 6487, 4710, 1829, 6701, 7424, 4433, 996,  5992, 1285, 6616, 1001, 3490, 8094, 1292, 6959,
    6100, 4909, 2645, 7823, 1189, 2973, 3007, 2175, 7975, 4188, 761,  6079, 4655, 8059, 4887, 7295, 2436, 1793, 1170,
    3376, 5472, 5113, 3882, 3860, 7713, 7793, 2543, 6706, 629,  3423, 2735, 7951, 263,  3069, 6819, 5300, 1260, 3361,
    7079, 1275, 6848, 2784, 3601, 334,  2062, 2778, 3756, 1160, 884,  851,  3217, 549,  111,  1926, 3105, 135,  4800,
    2966, 7733, 7429, 2205, 6999, 4611, 4790, 1985, 1065, 4343, 2080, 4143, 3570, 469,  3413, 3636, 5815, 4098, 7694,
    713,  2594, 3170, 7069, 2255, 7777, 4565, 145,  499,  3910, 6313, 6893, 4597, 870,  3309, 1175, 5184, 7359, 5600,
    976,  7136, 3435, 4477, 1864, 4164, 2154, 5649, 5170, 7811, 3607, 7963, 3265, 5803, 2126, 4331, 22,   3848, 5928,
    2050, 4217, 5312, 3986, 7655, 7164, 3483, 1352, 2413, 3381, 7171, 3944, 4440, 7605, 2009, 7486, 3325, 2887, 4057,
    3112, 3693, 362,  8146, 4983, 5451, 7462, 5240, 2681, 6501, 3081, 1601, 1496, 5663, 6940, 3974, 6024, 6489, 66,
    3253, 1240, 7124, 2441, 5552, 1698, 1831, 2689, 6718, 5564, 4712, 4663, 2134, 7016, 4178, 5771, 1849, 340,  1843,
    7805, 6842, 6134, 2635, 6759, 2031, 7391, 6064, 1145, 4724, 5125, 2070, 355,  2168, 2233, 6142, 1798, 3460, 5388,
    3626, 3771, 2904, 1548, 6911, 6368, 4767, 6159, 2768, 5686, 2827, 390,  530,  1532, 4940, 721,  3872, 6730, 6180,
    729,  7911, 808,  954,  8173, 4911, 5149, 4931, 4197, 6102, 4892, 1631, 2107, 7825, 7564, 1908, 8155, 2647, 2796,
    3197, 4313, 8096, 7045, 346,  6854, 3492, 3819, 4013, 1593, 6961, 7872, 1671, 203,  1294, 8122, 4606, 2730, 1287,
    2043, 4703, 2610, 5994, 7300, 7662, 2297, 1003, 1740, 5048, 2464, 6618, 2350, 7691, 142,  7426, 2077, 331,  546,
    6703, 5297, 6076, 3373, 998,  7820, 3621, 1826, 4435, 5595, 1529, 805,  1795, 6365, 7802, 1142, 2438, 4660, 7459,
    6937, 3378, 2884, 3262, 4214, 1172, 1861, 3279, 1949, 8061, 3725, 1855, 2790, 4657, 1858, 5294, 5592, 7297, 2347,
    3816, 8119, 4889, 2793, 613,  2836, 4190, 863,  7646, 4751, 7977, 8064, 6456, 5824, 6081, 6870, 305,  7322, 763,
    3728, 2500, 41,   2975, 240,  2672, 4235, 1191, 3282, 561,  2146, 2177, 6527, 417,  6229, 3009, 1952, 1035, 4273,
    3071, 899,  1384, 2843, 265,  766,  7923, 3582, 5302, 5786, 5942, 181,  6821, 3731, 1393, 569,  3425, 6192, 5777,
    7085, 631,  308,  7993, 1623, 7953, 3042, 6653, 2566, 2737, 7325, 446,  5846, 7795, 3246, 7706, 4952, 7715, 6084,
    3993, 7584, 6708, 917,  2315, 1889, 2545, 6873, 4525, 118,  5115, 5132, 6784, 5866, 5474, 6459, 1473, 7037, 3862,
    5910, 4021, 6793, 3884, 5827, 4414, 840,  853,  2940, 5853, 2532, 886,  7980, 157,  4779, 551,  5248, 5528, 4132,
    3219, 8067, 5811, 2962, 2780, 7789, 4184, 1281, 2064, 7649, 3099, 4427, 1162, 3835, 7378, 7111, 3758, 4754, 4231,
    4747, 2786, 1138, 542,  2606, 6850, 4193, 386,  2229, 336,  1236, 4979, 1348, 3603, 866,  5634, 7896, 3363, 5979,
    2953, 4552, 1262, 616,  4548, 2602, 1277, 2528, 5862, 4948, 7081, 2839, 5020, 170,  1067, 3508, 5722, 620,  1987,
    3012, 8001, 5899, 2082, 1077, 6394, 435,  4345, 1955, 2092, 4736, 7001, 1481, 7022, 1266, 2207, 420,  6984, 7638,
    4792, 4380, 692,  5517, 4613, 6232, 3565, 3356, 2968, 2761, 462,  4556, 4802, 2180, 5319, 5370, 7431, 7214, 5261,
    7534, 7735, 6530, 7343, 1933, 1928, 4731, 7891, 2957, 113,  564,  36,   1944, 137,  4308, 6154, 7011, 3107, 2149,
    8080, 1815, 7779, 3399, 453,  5983, 2257, 1194, 5731, 7553, 147,  2916, 8026, 3186, 4567, 3285, 6923, 1938, 2596,
    7031, 2140, 3367, 715,  2675, 2588, 8053, 7071, 3232, 3342, 406,  3172, 4238, 5753, 2222, 5817, 5381, 6992, 7900,
    3638, 2978, 4686, 5760, 7696, 3665, 4855, 5541, 4100, 243,  7255, 7348, 3572, 3545, 5890, 5638, 4145, 2503, 7545,
    6929, 3415, 4252, 7441, 3472, 471,  44,   945,  5079, 3437, 7195, 6572, 1959, 7138, 6824, 91,   7268, 1866, 8189,
    1422, 4506, 4479, 3734, 7863, 3290, 7361, 288,  6374, 4349, 5186, 5945, 218,  1405, 978,  6347, 4406, 3966, 5602,
    184,  6694, 6639, 872,  5620, 3558, 439,  4599, 5305, 6947, 5034, 1177, 1515, 6475, 2813, 3311, 5789, 2455, 4572,
    3912, 815,  643,  6398, 501,  7926, 3156, 249,  6895, 6687, 3827, 6751, 6315, 3585, 296,  6274, 5930, 6665, 5834,
    1081, 3850, 268,  2516, 5501, 4219, 7470, 4120, 1764, 2052, 769,  3273, 3191, 2128, 4158, 6917, 2086, 5805, 1387,
    2749, 7231, 24,   823,  1254, 522,  4333, 2846, 7288, 1649, 3609, 7054, 4301, 5903, 7813, 3074, 2872, 51,   3267,
    7857, 6217, 3530, 7965, 902,  796,  8031, 2156, 3522, 1686, 8005, 4166, 1038, 5158, 4106, 5172, 6680, 1340, 1540,
    5651, 4276, 6833, 4640, 7488, 744,  6038, 3016, 2011, 2740, 316,  5279, 2889, 484,  1369, 371,  3327, 7328, 57,
    2921, 3946, 6467, 1554, 1991, 7173, 6656, 1104, 5426, 7607, 5954, 2307, 2001, 4442, 2569, 6902, 3141, 1354, 6289,
    2200, 624,  3485, 7956, 5670, 1724, 3383, 3026, 1309, 7935, 2415, 3045, 381,  152,  3988, 7918, 4681, 5726, 5314,
    7996, 3455, 5547, 7166, 5179, 6451, 7454, 7657, 1626, 8137, 1047, 1498, 2369, 3891, 3512, 1603, 634,  2867, 2511,
    6942, 86,   75,   2862, 5665, 311,  2878, 7558, 2683, 970,  2910, 1071, 5242, 5780, 6440, 4041, 3083, 5004, 7945,
    4323, 6503, 7088, 6304, 5695, 4985, 6253, 428,  174,  8148, 3428, 80,   478,  7464, 8183, 277,  6562, 5453, 6195,
    2117, 5736, 3114, 5071, 5490, 5024, 4059, 1396, 4290, 4861, 364,  4499, 4265, 3902, 3695, 572,  4516, 3122, 5566,
    666,  2390, 6236, 6720, 2548, 2374, 7755, 4665, 6201, 1115, 4868, 4714, 6876, 908,  1199, 1700, 1096, 3777, 4617,
    5554, 2318, 5207, 3789, 2691, 1969, 6976, 4005, 1833, 1892, 256,  1565, 1242, 7673, 8019, 5521, 3255, 6711, 1503,
    594,  2443, 2327, 3954, 4359, 7126, 920,  2557, 2262, 6026, 736,  1712, 696,  3976, 3996, 5059, 3671, 68,   4113,
    3500, 5141, 6491, 7587, 7369, 6408, 7393, 5219, 6800, 4384, 2033, 7718, 1052, 4085, 1147, 5459, 3678, 6049, 6066,
    6087, 7971, 5988, 6136, 2407, 3632, 4796, 6844, 7709, 2703, 4818, 6761, 3920, 7727, 6610, 2637, 4955, 327,  4699,
    342,  4927, 2668, 7642, 1851, 7798, 8142, 3479, 7807, 4593, 2823, 2164, 1845, 3249, 7887, 458,  7018, 5718, 5886,
    6988, 2136, 449,  6780, 7702, 5773, 1380, 2949, 538,  4180, 5849, 4677, 2196, 1550, 6034, 5486, 424,  2906, 3887,
    639,  3554, 6370, 6568, 1682, 4297, 6913, 5830, 3536, 3404, 5390, 5482, 5394, 2211, 3462, 4024, 1708, 8015, 3773,
    2386, 5882, 2664, 3628, 6796, 3163, 3208, 2235, 1320, 3408, 1270, 2170, 3865, 1608, 4537, 1800, 7519, 2282, 1127,
    6144, 5913, 5974, 7784, 5127, 6187, 3540, 7026, 4726, 1476, 5681, 5766, 357,  5165, 235,  3720, 2072, 7040, 5713,
    2402, 731,  1091, 4028, 1485, 6182, 5477, 3517, 4153, 810,  283,  5066, 965,  7913, 6462, 6223, 1820, 723,  1490,
    3466, 7005, 4942, 6787, 1774, 6169, 6732, 5348, 7771, 1787, 3874, 5869, 1919, 2998, 392,  3651, 2215, 4740, 2829,
    5118, 3896, 7448, 1534, 6745, 5578, 3714, 532,  5135, 5361, 8085, 6161, 4033, 5398, 2096, 4769, 4528, 2991, 4692,
    5688, 1642, 8045, 5584, 2770, 121,  102,  5744, 8157, 6118, 7523, 6534, 1910, 3222, 5009, 5411, 2798, 6259, 4369,
    579,  2649, 8070, 7060, 4243, 2109, 5353, 1804, 7739, 1633, 5531, 4844, 4068, 7566, 1433, 2492, 7247, 7827, 4135,
    3592, 706,  4199, 2715, 4541, 7538, 4933, 554,  3088, 1450, 4894, 5098, 2929, 6583, 6104, 5251, 3060, 3177, 8175,
    6737, 1612, 5265, 956,  160,  6773, 2984, 5151, 4283, 6862, 3657, 4913, 4782, 3298, 6385, 205,  7182, 5917, 7218,
    1673, 889,  4046, 6549, 8124, 4991, 7594, 4627, 1296, 7983, 3615, 411,  1595, 6174, 6148, 7435, 4015, 5856, 2020,
    6597, 7874, 4580, 2430, 2249, 6963, 2535, 4878, 128,  6856, 8105, 1131, 5374, 348,  856,  6445, 4259, 3821, 1334,
    229,  8039, 3494, 2943, 7415, 3347, 4315, 1779, 2286, 5323, 3199, 4417, 4920, 3644, 7047, 6246, 8111, 398,  8098,
    843,  7147, 1464, 2466, 2270, 1324, 2184, 5050, 3761, 7093, 5336, 2352, 5701, 7405, 3702, 6620, 4757, 1655, 3237,
    2299, 5874, 2239, 4806, 7664, 7381, 1207, 654,  1742, 5195, 1663, 684,  1005, 7114, 6322, 6812, 2612, 4394, 3212,
    4560, 4705, 1165, 6508, 7845, 7302, 784,  2482, 510,  5996, 3838, 3753, 7076, 2732, 3879, 3167, 466,  4608, 3102,
    6059, 7906, 2045, 5658, 4884, 3004, 1289, 4430, 2632, 4175, 1828, 6486, 3869, 2765, 3623, 2067, 4328, 5646, 5597,
    6310, 6498, 3690, 4437, 7652, 7294, 8058, 3375, 1792, 2174, 2972, 6078, 4187, 6958, 8093, 7822, 4908, 995,  7423,
    1000, 1284, 1159, 2777, 548,  850,  1274, 3360, 333,  2783, 7950, 3422, 5299, 3068, 3859, 5112, 6705, 7792, 7068,
    2593, 144,  7776, 3412, 3569, 7693, 5814, 4789, 6998, 2079, 1064, 134,  1925, 7428, 2965, 21,   2125, 4216, 5927,
    5169, 2153, 3264, 3606, 975,  7358, 1863, 3434, 6892, 3909, 1174, 869,  3080, 2680, 6939, 1495, 361,  3111, 7461,
    4982, 7604, 3943, 2886, 7485, 7163, 3985, 3380, 1351, 6758, 6133, 1144, 7390, 5770, 7015, 7804, 339,  2688, 1697,
    4662, 5563, 65,   6023, 2440, 1239, 6729, 720,  807,  728,  5685, 6158, 1531, 389,  3770, 5387, 6367, 1547, 354,
    5124, 1797, 2232, 7871, 1592, 8121, 202,  7044, 4312, 3818, 6853, 7563, 2106, 2795, 8154, 5148, 8172, 4891, 4196,
    7819, 3372, 5594, 1825, 2076, 141,  5296, 545,  1739, 2296, 2349, 2463, 2042, 2729, 7299, 2609, 2346, 5591, 2792,
    8118, 3724, 1948, 1857, 2789, 2883, 6936, 1860, 4213, 6364, 804,  4659, 1141, 6526, 2145, 1951, 6228, 239,  40,
    3281, 4234, 6869, 5823, 3727, 7321, 862,  2835, 8063, 4750, 3041, 1622, 7324, 2565, 6191, 568,  307,  7084, 5785,
    3581, 3730, 180,  898,  4272, 765,  2842, 5909, 7036, 5826, 6792, 5131, 117,  6458, 5865, 916,  7583, 6872, 1888,
    3245, 5845, 6083, 4951, 3834, 4426, 4753, 7110, 7788, 2961, 7648, 1280, 5247, 4778, 8066, 4131, 2939, 839,  7979,
    2531, 2527, 2601, 2838, 4947, 5978, 7895, 615,  4551, 1235, 2228, 865,  1347, 1137, 4746, 4192, 2605, 4379, 7637,
    6231, 5516, 1480, 4735, 419,  1265, 1076, 5898, 1954, 434,  3507, 169,  3011, 619,  4307, 1943, 2148, 7010, 4730,
    1932, 563,  2956, 7213, 5369, 6529, 7533, 2760, 3355, 2179, 4555, 3231, 8052, 4237, 405,  7030, 1937, 2674, 3366,
    2915, 7552, 3284, 3185, 3398, 1814, 1193, 5982, 4251, 6928, 43,   3471, 3544, 7347, 2502, 5637, 3664, 5759, 242,
    5540, 5380, 2221, 2977, 7899, 6346, 1404, 183,  3965, 287,  3289, 5944, 4348, 8188, 7267, 3733, 4505, 7194, 5078,
    6823, 1958, 6686, 248,  3584, 6750, 814,  4571, 7925, 6397, 1514, 5033, 5788, 2812, 5619, 6638, 5304, 438,  822,
    7230, 2845, 521,  4157, 3190, 1386, 2085, 7469, 5500, 768,  1763, 6664, 6273, 267,  1080, 6679, 4105, 4275, 1539,
    3521, 8030, 1037, 8004, 7856, 50,   901,  3529, 7053, 1648, 3073, 5902, 5953, 5425, 2568, 2000, 6466, 2920, 6655,
    1990, 483,  5278, 7327, 370,  743,  4639, 2739, 3015, 5178, 5546, 1625, 7453, 7917, 151,  7995, 5725, 3025, 1723,
    3044, 7934, 6288, 3140, 7955, 623,  5003, 4040, 7087, 4322, 969,  7557, 5779, 1070, 85,   2510, 310,  2861, 2368,
    1046, 633,  3511, 4498, 4860, 571,  3901, 5070, 5735, 1395, 5023, 8182, 477,  6194, 6561, 6252, 5694, 3427, 173,
    1968, 3788, 1891, 4004, 1095, 1198, 2317, 4616, 6200, 7754, 6875, 4867, 665,  3121, 2547, 6235, 4112, 3670, 7586,
    5140, 735,  2261, 3995, 695,  2326, 593,  919,  4358, 7672, 1564, 6710, 5520, 3919, 4817, 4954, 6609, 2406, 5987,
    7708, 4795, 5458, 4084, 6086, 6048, 5218, 6407, 7717, 4383, 1379, 7701, 5848, 537,  5717, 457,  448,  6987, 4592,
    3478, 3248, 2163, 4926, 4698, 7797, 7641, 2385, 8014, 6795, 2663, 5481, 3403, 4023, 2210, 6567, 3553, 5829, 4296,
    6033, 2195, 3886, 423,  5164, 5765, 7039, 3719, 6186, 7783, 1475, 7025, 7518, 4536, 5912, 1126, 1319, 3207, 3864,
    1269, 5347, 6168, 5868, 1786, 1489, 1819, 6786, 7004, 282,  4152, 6461, 964,  1090, 2401, 5476, 1484, 1641, 4691,
    120,  5583, 4032, 8084, 4527, 2095, 6744, 7447, 5134, 3713, 3650, 2997, 5117, 4739, 1432, 4067, 4134, 7246, 5352,
    4242, 5530, 7738, 6258, 5410, 8069, 578,  6117, 5743, 3221, 6533, 4282, 2983, 4781, 3656, 6736, 3176, 159,  5264,
    5097, 1449, 5250, 6582, 2714, 705,  553,  7537, 4579, 6596, 2534, 2248, 6173, 410,  5855, 7434, 4990, 6548, 7982,
    4626, 7181, 6384, 888,  7217, 6245, 3643, 842,  397,  1778, 3346, 4416, 5322, 1333, 4258, 2942, 8038, 8104, 127,
    855,  5373, 5194, 653,  7113, 683,  5873, 3236, 7380, 4805, 5700, 5335, 4756, 3701, 2269, 1463, 3760, 2183, 5657,
    7905, 4429, 3003, 3878, 7075, 3101, 465,  783,  7844, 3837, 509,  4393, 6811, 1164, 4559, 4907, 8092, 1283, 7422,
    1791, 8057, 4186, 2971, 6309, 5645, 7651, 3689, 6485, 4174, 2066, 2764, 1063, 6997, 2964, 1924, 7775, 2592, 5813,
    3568, 3067, 3421, 7791, 5111, 849,  2776, 2782, 3359, 7484, 3942, 1350, 3984, 1494, 2679, 4981, 3110, 3433, 7357,
    868,  3908, 5926, 2124, 3605, 2152, 1546, 5386, 2231, 5123, 727,  719,  388,  6157, 5562, 1696, 1238, 6022, 7389,
    6132, 338,  7014, 2462, 2295, 2608, 2728, 1824, 3371, 544,  140,  8153, 2105, 4195, 8171, 201,  1591, 6852, 4311,
    7320, 5822, 4749, 2834, 6227, 2144, 4233, 39,   4212, 6935, 1140, 803,  8117, 5590, 2788, 1947, 1887, 7582, 4950,
    5844, 6791, 7035, 5864, 116,  179,  3580, 2841, 4271, 2564, 1621, 7083, 567,  1346, 2227, 2604, 4745, 4946, 2600,
    4550, 7894, 4130, 4777, 2530, 838,  7109, 4425, 1279, 2960, 7532, 5368, 4554, 3354, 7009, 1942, 2955, 1931, 433,
    5897, 618,  168,  5515, 7636, 1264, 4734, 5539, 5758, 7898, 2220, 3470, 6927, 5636, 7346, 3184, 7551, 5981, 1813,
    404,  8051, 3365, 1936, 2811, 5032, 437,  6637, 6749, 247,  6396, 4570, 4504, 7266, 1957, 5077, 3964, 1403, 4347,
    3288, 3528, 49,   5901, 1647, 1538, 4104, 8003, 8029, 1762, 5499, 1079, 6272, 520,  7229, 2084, 3189, 7933, 1722,
    622,  3139, 7452, 5545, 5724, 150,  369,  5277, 3014, 4638, 1999, 5424, 1989, 2919, 6560, 476,  172,  5693, 3900,
    4859, 5022, 5734, 2860, 2509, 3510, 1045, 4321, 4039, 1069, 7556, 4357, 592,  5519, 1563, 5139, 3669, 694,  2260,
    4866, 7753, 6234, 3120, 4003, 3787, 4615, 1197, 2162, 3477, 7640, 4697, 536,  7700, 6986, 456,  6047, 4083, 4382,
    6406, 6608, 4816, 4794, 5986, 1125, 4535, 1268, 3206, 3718, 5764, 7024, 7782, 4295, 3552, 422,  2194, 2662, 8013,
    2209, 3402, 3712, 7446, 4738, 2996, 5582, 4690, 2094, 8083, 963,  4151, 1483, 2400, 1785, 6167, 7003, 1818, 6581,
    1448, 7536, 704,  3655, 2982, 5263, 3175, 577,  5409, 6532, 5742, 7245, 4066, 7737, 4241, 8037, 4257, 5372, 126,
    396,  3642, 5321, 3345, 4625, 6547, 7216, 6383, 2247, 6595, 7433, 409,  508,  7843, 4558, 6810, 3002, 7904, 464,
    7074, 3700, 5334, 2182, 1462, 682,  652,  4804, 3235, 5110, 3420, 3358, 2775, 1923, 6996, 3567, 2591, 3688, 5644,
    2763, 4173, 7421, 8091, 2970, 8056, 6021, 1695, 7013, 6131, 5122, 5385, 6156, 718,  3907, 7356, 2151, 2123, 3983,
    3941, 3109, 2678, 802,  6934, 1946, 5589, 2833, 5821, 38,   2143, 8170, 2104, 4310, 1590, 2727, 2294, 139,  3370,
    837,  4776, 2959, 4424, 4744, 2226, 7893, 2599, 4270, 3579, 566,  1620, 5843, 7581, 115,  7034, 1812, 7550, 1935,
    8050, 2219, 5757, 7345, 6926, 167,  5896, 4733, 7635, 3353, 5367, 1930, 1941, 6271, 5498, 3188, 7228, 1646, 48,
    8028, 4103, 5076, 7265, 3287, 1402, 6636, 5031, 4569, 246,  1044, 2508, 7555, 4038, 5692, 475,  5733, 4858, 4637,
    5276, 2918, 5423, 3138, 1721, 149,  5544, 6405, 4082, 5985, 4815, 4696, 3476, 455,  7699, 3119, 7752, 1196, 3786,
    1562, 591,  2259, 3668, 2399, 4150, 1817, 6166, 2995, 7445, 8082, 4689, 2193, 3551, 3401, 8012, 3205, 4534, 7781,
    5763, 6382, 6546, 408,  6594, 125,  4256, 3344, 3641, 5741, 5408, 4240, 4065, 703,  1447, 3174, 2981, 4172, 5643,
    8055, 8090, 2774, 3419, 2590, 6995, 1461, 5333, 3234, 651,  6809, 7842, 7073, 7903, 1589, 2103, 3369, 2293, 5588,
    6933, 2142, 5820, 2122, 7355, 2677, 3940, 6130, 1694, 717,  5384, 7634, 5895, 1940, 5366, 8049, 7549, 6925, 5756,
    1619, 3578, 7033, 7580, 4423, 4775, 2598, 2225, 5422, 5275, 5543, 1720, 4037, 2507, 4857, 474,  1401, 7264, 245,
    5030, 7227, 5497, 4102, 47,   8011, 3550, 5762, 4533, 6165, 4149, 4688, 7444, 3785, 7751, 3667, 590,  4814, 4081,
    7698, 3475, 650,  5332, 7902, 7841, 8089, 5642, 6994, 3418, 4064, 5407, 2980, 1446, 6593, 6545, 3640, 4255, 7579,
    3577, 2224, 4774, 5365, 5894, 5755, 7548, 3939, 7354, 5383, 1693, 2292, 2102, 5819, 6932, 589,  7750, 3474, 4080,
    4532, 3549, 7443, 4148, 5029, 7263, 46,   5496, 1719, 5274, 473,  2506, 1692, 7353, 6931, 2101, 4773, 3576, 7547,
    5893, 1445, 5406, 4254, 6544, 7840, 5331, 3417, 5641, 6543, 5405, 5640, 5330, 2100, 7352, 5892, 3575, 5495, 7262,
    2505, 5273, 4079, 7749, 4147, 3548, 7747, 7260, 7350, 5403, 5402, 7259, 7257, 7258, 5272, 7261, 3547, 7748, 5329,
    5404, 3574, 7351};
