
#include <stdint.h>

// GF2^9
const uint16_t gf2_12_expTab[4095] = {
    1,    7,    21,   107,  273,  1911, 1100, 3565, 401,  1271, 3788, 2166, 2393, 3732, 2558, 3553, 437,  1035, 3128,
    1210, 3887, 3551, 271,  1837, 1482, 2431, 3686, 2848, 507,  1505, 2478, 3153, 1445, 2162, 2373, 3776, 2130, 2469,
    3168, 1330, 2967, 766,  3322, 1780, 197,  603,  3969, 3733, 2553, 3572, 478,  1306, 2895, 246,  706,  3150, 1528,
    2529, 3516, 38,   242,  734,  3098, 1108, 3493, 105,  287,  1885, 1178, 4047, 3967, 3183, 1311, 2900, 183,  773,
    2331, 3930, 3220, 2046, 2035, 2000, 1849, 1446, 2171, 2426, 3709, 2913, 60,   180,  780,  2340, 4071, 4007, 3687,
    2855, 494,  1418, 2239, 2854, 489,  1439, 2260, 2615, 1694, 467,  1337, 2982, 617,  3871, 3407, 767,  3325, 1761,
    174,  842,  2294, 2777, 1044, 3173, 1321, 3030, 825,  2479, 3158, 1456, 2073, 2132, 2487, 3102, 1096, 3569, 453,
    1371, 2696, 1443, 2144, 2363, 4026, 3636, 2718, 1473, 2382, 3825, 2245, 2624, 2011, 1800, 1329, 2974, 705,  3143,
    1479, 2396, 3727, 2495, 3110, 1248, 3753, 2381, 3832, 2298, 2813, 1256, 3729, 2533, 3488, 114,  350,  1690, 463,
    1389, 2570, 1581, 714,  3190, 1360, 2745, 1332, 2949, 640,  3456, 146,  1022, 3066, 1021, 3059, 962,  2894, 241,
    727,  3109, 1257, 3734, 2544, 3531, 355,  1577, 726,  3106, 1276, 3837, 2273, 2748, 1327, 3012, 839,  2261, 2608,
    1675, 440,  1064, 3281, 1573, 754,  3294, 1544, 561,  3735, 2551, 3550, 264,  1848, 1441, 2158, 2321, 3948, 3094,
    1136, 3417, 669,  3539, 299,  2001, 1854, 1459, 2064, 2155, 2314, 3885, 3537, 293,  2043, 2024, 1937, 1790, 243,
    729,  3087, 1087, 3252, 1822, 1363, 2736, 1291, 2872, 435,  1049, 3142, 1472, 2377, 3812, 2222, 2897, 172,  836,
    2268, 2575, 1590, 651,  3505, 5,    27,   65,   455,  1365, 2722, 1397, 2626, 2005, 1826, 1511, 2492, 3119, 1247,
    3604, 2686, 1889, 1070, 3267, 1627, 904,  2744, 1331, 2960, 747,  3217, 2021, 1970, 1559, 620,  3844, 3342, 824,
    2472, 3139, 1499, 2312, 3875, 3579, 499,  1497, 2310, 3849, 3373, 977,  2871, 414,  1242, 3599, 2623, 1702, 379,
    1633, 814,  2506, 3437, 529,  3703, 2903, 190,  826,  2470, 3177, 1293, 2858, 461,  1379, 2592, 1787, 232,  664,
    3528, 362,  1558, 619,  3857, 3429, 553,  3807, 2063, 2102, 2201, 3028, 823,  2437, 3200, 1938, 1783, 204,  612,
    3900, 3494, 96,   288,  2016, 1961, 1622, 939,  2641, 1964, 1613, 1002, 2966, 761,  3311, 1695, 468,  1324, 3021,
    888,  2152, 2307, 3858, 3436, 534,  3682, 2876, 431,  1101, 3562, 388,  1180, 4061, 3841, 3349, 889,  2159, 2326,
    3961, 3197, 1377, 2606, 1745, 62,   186,  806,  2546, 3525, 329,  1791, 244,  716,  3172, 1326, 3011, 850,  2238,
    2849, 508,  1524, 2501, 3392, 722,  3134, 1192, 3921, 3237, 1897, 1046, 3179, 1283, 2816, 283,  1857, 1230, 3683,
    2875, 442,  1062, 3323, 1779, 208,  560,  3728, 2530, 3509, 25,   79,   493,  1411, 2176, 2971, 730,  3078, 1024,
    3081, 1069, 3274, 1636, 821,  2443, 3242, 1860, 1237, 3618, 2812, 1263, 3716, 2446, 3249, 1797, 1298, 2935, 94,
    410,  1222, 3675, 2963, 738,  3246, 1880, 1153, 3982, 3768, 2362, 4029, 3617, 2805, 1232, 3641, 2749, 1320, 3025,
    812,  2500, 3399, 711,  3157, 1465, 2086, 2281, 2692, 1415, 2204, 3023, 886,  2114, 2517, 3376, 898,  2702, 1457,
    2078, 2113, 2524, 3343, 831,  2493, 3112, 1226, 3711, 2927, 22,   98,   302,  1994, 1919, 1140, 3397, 713,  3199,
    1391, 2564, 1543, 540,  3668, 3006, 545,  3815, 2215, 2926, 17,   119,  325,  1755, 8,    56,   168,  856,  2184,
    2979, 626,  3934, 3208, 1962, 1631, 916,  2796, 1183, 4052, 3902, 3496, 74,   502,  1474, 2375, 3790, 2168, 2419,
    3650, 3036, 783,  2349, 4056, 3866, 3412, 702,  3386, 948,  2572, 1599, 692,  3340, 822,  2434, 3221, 2041, 2022,
    1979, 1576, 721,  3127, 1175, 4076, 3990, 3824, 2242, 2645, 1968, 1561, 582,  4050, 3884, 3542, 304,  1936, 1785,
    230,  690,  3358, 840,  2296, 2803, 1218, 3655, 3015, 846,  2282, 2701, 1464, 2081, 2300, 2799, 1174, 4075, 3971,
    3739, 2515, 3362, 1020, 3060, 983,  2853, 480,  1440, 2153, 2308, 3847, 3335, 775,  2325, 3952, 3138, 1500, 2333,
    3912, 3306, 1668, 405,  1259, 3736, 2522, 3357, 833,  2247, 2638, 2033, 2014, 1811, 1392, 2649, 1940, 1765, 178,
    798,  2394, 3741, 2497, 3420, 646,  3474, 236,  644,  3484, 198,  594,  4030, 3624, 2762, 1133, 3338, 804,  2556,
    3567, 415,  1245, 3610, 2644, 1975, 1548, 557,  3779, 2139, 2458, 3293, 1537, 526,  3626, 2756, 1095, 3548, 262,
    1810, 1399, 2636, 2047, 2036, 1989, 1874, 1207, 3852, 3382, 912,  2800, 1227, 3704, 2938, 125,  371,  1625, 902,
    2706, 1509, 2482, 3077, 1033, 3126, 1168, 4089, 4093, 4065, 4021, 3609, 2653, 1928, 1713, 286,  1882, 1167, 4004,
    3694, 2840, 339,  1721, 294,  2034, 2007, 1836, 1485, 2410, 3597, 2609, 1676, 429,  1091, 3520, 338,  1726, 307,
    1945, 1734, 91,   385,  1159, 3996, 3782, 2112, 2523, 3354, 852,  2220, 2911, 134,  914,  2814, 1249, 3758, 2392,
    3731, 2539, 3466, 164,  892,  2164, 2391, 3774, 2344, 4035, 3931, 3219, 2027, 1944, 1729, 78,   490,  1430, 2283,
    2698, 1453, 2122, 2541, 3480, 218,  518,  3602, 2668, 1823, 1364, 2725, 1376, 2601, 1732, 85,   427,  1105, 3518,
    40,   216,  520,  3640, 2746, 1341, 3002, 573,  3763, 2315, 3882, 3524, 334,  1770, 159,  989,  2835, 354,  1582,
    707,  3145, 1517, 2442, 3245, 1873, 1214, 3891, 3467, 163,  873,  2079, 2118, 2505, 3428, 558,  3786, 2148, 2343,
    4078, 3992, 3802, 2068, 2167, 2398, 3713, 2453, 3312, 1730, 71,   469,  1323, 3032, 787,  2425, 3700, 2910, 129,
    903,  2709, 1520, 2521, 3348, 894,  2170, 2429, 3688, 2826, 301,  1987, 1856, 1225, 3702, 2896, 171,  849,  2231,
    2846, 321,  1735, 92,   404,  1260, 3725, 2481, 3084, 1078, 3211, 1955, 1632, 809,  2527, 3334, 768,  2304, 3867,
    3411, 683,  3409, 677,  3451, 627,  3929, 3229, 1985, 1870, 1251, 3744, 2418, 3653, 3017, 868,  2108, 2223, 2902,
    185,  815,  2509, 3448, 634,  3942, 3104, 1266, 3799, 2103, 2206, 3009, 860,  2196, 3063, 990,  2842, 349,  1683,
    496,  1488, 2361, 4020, 3614, 2632, 2019, 1952, 1641, 790,  2402, 3637, 2713, 1492, 2341, 4064, 4018, 3596, 2614,
    1689, 454,  1362, 2743, 1310, 2899, 162,  878,  2058, 2093, 2264, 2579, 1634, 807,  2549, 3536, 290,  2030, 1923,
    1664, 393,  1215, 3892, 3486, 200,  632,  3944, 3082, 1060, 3317, 1753, 6,    18,   126,  378,  1638, 827,  2465,
    3196, 1382, 2619, 1722, 303,  1997, 1898, 1055, 3156, 1470, 2099, 2178, 2965, 752,  3280, 1570, 743,  3253, 1817,
    1350, 2779, 1050, 3151, 1535, 2548, 3543, 311,  1925, 1682, 503,  1477, 2386, 3749, 2409, 3588, 2574, 1585, 670,
    3546, 276,  1900, 1037, 3114, 1220, 3669, 3001, 564,  3724, 2486, 3097, 1117, 3482, 212,  556,  3780, 2126, 2545,
    3532, 374,  1602, 967,  2901, 176,  784,  2416, 3659, 3043, 946,  2590, 1601, 974,  2922, 13,   35,   233,  671,
    3549, 257,  1799, 1308, 2909, 136,  952,  2600, 1731, 64,   448,  1344, 2761, 1124, 3381, 921,  2767, 1142, 3403,
    739,  3241, 1869, 1258, 3743, 2511, 3446, 592,  4016, 3586, 2588, 1615, 996,  3004, 559,  3789, 2161, 2380, 3839,
    2287, 2710, 1529, 2534, 3497, 77,   483,  1449, 2134, 2489, 3124, 1182, 4051, 3883, 3523, 347,  1665, 398,  1194,
    3935, 3215, 1983, 1588, 645,  3483, 211,  569,  3759, 2399, 3718, 2432, 3227, 2003, 1840, 1433, 2246, 2633, 2020,
    1973, 1538, 519,  3605, 2681, 1908, 1093, 3538, 300,  1988, 1877, 1186, 3943, 3111, 1255, 3772, 2342, 4073, 3981,
    3761, 2309, 3840, 3346, 876,  2052, 2055, 2062, 2097, 2188, 3007, 550,  3826, 2252, 2687, 1894, 1083, 3240, 1866,
    1279, 3828, 2270, 2561, 1564, 605,  3987, 3819, 2179, 2962, 741,  3259, 1843, 1424, 2297, 2804, 1239, 3628, 2774,
    1081, 3238, 1888, 1065, 3286, 1584, 665,  3535, 383,  1661, 890,  2150, 2345, 4036, 3918, 3320, 1786, 239,  653,
    3491, 123,  353,  1575, 764,  3316, 1758, 19,   121,  367,  1549, 554,  3798, 2096, 2187, 2986, 589,  4067, 4027,
    3635, 2699, 1450, 2143, 2438, 3209, 1965, 1610, 1023, 3069, 1000, 2968, 723,  3129, 1213, 3898, 3508, 30,   90,
    390,  1170, 4087, 4055, 3895, 3479, 247,  709,  3163, 1427, 2288, 2763, 1130, 3359, 847,  2285, 2712, 1491, 2352,
    3979, 3747, 2427, 3706, 2932, 87,   421,  1147, 3432, 522,  3638, 2704, 1515, 2456, 3283, 1579, 728,  3080, 1066,
    3295, 1551, 548,  3836, 2278, 2729, 1348, 2773, 1072, 3225, 2013, 1818, 1359, 2788, 1191, 3964, 3174, 1312, 3049,
    900,  2716, 1487, 2404, 3623, 2791, 1198, 3907, 3291, 1555, 624,  3920, 3234, 1916, 1149, 3450, 628,  3916, 3318,
    1744, 57,   175,  845,  2275, 2738, 1285, 2834, 357,  1595, 680,  3416, 666,  3526, 320,  1728, 73,   511,  1533,
    2554, 3581, 481,  1447, 2172, 2415, 3606, 2672, 1867, 1272, 3809, 2229, 2832, 363,  1553, 638,  3962, 3188, 1374,
    2707, 1506, 2471, 3182, 1304, 2881, 220,  532,  3692, 2838, 377,  1647, 772,  2332, 3919, 3327, 1775, 132,  924,
    2772, 1079, 3212, 1974, 1547, 568,  3752, 2378, 3821, 2193, 3052, 927,  2781, 1032, 3121, 1157, 3986, 3820, 2198,
    3065, 1012, 3020, 895,  2173, 2408, 3587, 2587, 1626, 911,  2733, 1368, 2689, 1436, 2269, 2568, 1571, 736,  3232,
    1906, 1111, 3500, 86,   418,  1134, 3331, 795,  2369, 3804, 2054, 2057, 2084, 2279, 2734, 1361, 2750, 1313, 3054,
    913,  2807, 1246, 3603, 2667, 1802, 1343, 2996, 535,  3685, 2857, 452,  1372, 2717, 1480, 2417, 3660, 3062, 985,
    2831, 310,  1922, 1671, 412,  1236, 3621, 2793, 1156, 3989, 3833, 2301, 2792, 1155, 3968, 3730, 2540, 3487, 207,
    621,  3843, 3355, 851,  2233, 2868, 407,  1253, 3762, 2316, 3903, 3503, 95,   413,  1235, 3632, 2690, 1429, 2274,
    2741, 1296, 2937, 116,  332,  1764, 181,  779,  2353, 3980, 3766, 2320, 3947, 3075, 1051, 3144, 1514, 2463, 3270,
    1600, 969,  2943, 102,  306,  1950, 1747, 48,   144,  1008, 3024, 811,  2513, 3372, 982,  2850, 501,  1483, 2424,
    3699, 2891, 234,  662,  3554, 444,  1076, 3205, 1929, 1718, 267,  1841, 1438, 2259, 2594, 1781, 194,  590,  4074,
    3972, 3726, 2488, 3123, 1163, 4024, 3642, 2740, 1303, 2924, 31,   93,   403,  1273, 3814, 2208, 2939, 122,  358,
    1586, 663,  3557, 425,  1119, 3476, 254,  762,  3302, 1696, 361,  1567, 596,  4012, 3670, 2992, 523,  3633, 2693,
    1408, 2185, 2980, 615,  3893, 3481, 221,  531,  3705, 2941, 104,  280,  1864, 1265, 3806, 2056, 2083, 2290, 2757,
    1088, 3529, 365,  1539, 512,  3584, 2578, 1637, 818,  2462, 3265, 1621, 930,  2670, 1809, 1406, 2675, 1858, 1223,
    3676, 2950, 649,  3519, 47,   205,  611,  3881, 3533, 369,  1623, 940,  2628, 1991, 1884, 1181, 4058, 3860, 3454,
    616,  3864, 3418, 660,  3564, 406,  1250, 3751, 2407, 3630, 2776, 1043, 3184, 1346, 2759, 1102, 3555, 443,  1057,
    3310, 1688, 449,  1351, 2780, 1039, 3108, 1262, 3715, 2459, 3290, 1556, 613,  3899, 3507, 11,   49,   151,  997,
    3003, 570,  3750, 2400, 3643, 2739, 1282, 2823, 270,  1834, 1503, 2324, 3959, 3159, 1463, 2060, 2111, 2214, 2921,
    4,    28,   84,   428,  1092, 3541, 313,  1967, 1604, 981,  2859, 458,  1398, 2635, 2026, 1951, 1748, 37,   251,
    737,  3239, 1895, 1084, 3261, 1825, 1518, 2435, 3218, 2028, 1933, 1706, 351,  1693, 474,  1286, 2843, 346,  1670,
    411,  1217, 3662, 3064, 1011, 3033, 788,  2412, 3615, 2639, 2038, 1995, 1912, 1121, 3374, 984,  2824, 291,  2025,
    1942, 1771, 152,  968,  2936, 115,  345,  1679, 420,  1148, 3453, 609,  3879, 3559, 423,  1141, 3394, 732,  3092,
    1150, 3443, 587,  4081, 4037, 3913, 3309, 1681, 510,  1530, 2543, 3478, 240,  720,  3120, 1154, 3975, 3719, 2439,
    3214, 1976, 1569, 750,  3210, 1956, 1653, 834,  2254, 2673, 1868, 1261, 3722, 2468, 3175, 1319, 3068, 1007, 2957,
    696,  3368, 970,  2934, 89,   399,  1197, 3914, 3300, 1710, 323,  1737, 118,  322,  1742, 99,   297,  2015, 1812,
    1381, 2610, 1669, 402,  1278, 3827, 2251, 2666, 1805, 1322, 3039, 774,  2322, 3941, 3113, 1229, 3690, 2820, 263,
    1813, 1378, 2599, 1774, 131,  905,  2751, 1318, 3067, 1018, 3046, 937,  2655, 1926, 1691, 456,  1400, 2657, 1852,
    1469, 2106, 2237, 2856, 451,  1353, 2806, 1241, 3590, 2560, 1563, 584,  4088, 4090, 4084, 4062, 3848, 3370, 964,
    2908, 143,  941,  2627, 2002, 1847, 1420, 2221, 2904, 147,  1017, 3055, 918,  2786, 1205, 3842, 3356, 838,  2258,
    2597, 1760, 169,  863,  2205, 3016, 867,  2089, 2244, 2631, 1998, 1891, 1056, 3305, 1677, 426,  1110, 3499, 67,
    457,  1407, 2676, 1879, 1196, 3917, 3313, 1733, 82,   446,  1082, 3247, 1887, 1172, 4069, 4009, 3661, 3057, 972,
    2916, 39,   245,  715,  3185, 1349, 2770, 1061, 3314, 1740, 109,  259,  1801, 1334, 2955, 682,  3414, 688,  3344,
    866,  2094, 2257, 2604, 1759, 20,   108,  260,  1820, 1373, 2714, 1501, 2330, 3933, 3201, 1941, 1762, 167,  885,
    2123, 2538, 3469, 177,  791,  2405, 3616, 2802, 1221, 3666, 2988, 607,  3997, 3777, 2133, 2480, 3083, 1059, 3296,
    1714, 279,  1893, 1074, 3223, 2039, 1996, 1901, 1034, 3135, 1199, 3908, 3278, 1656, 865,  2087, 2286, 2705, 1516,
    2445, 3256, 1850, 1455, 2116, 2503, 3406, 760,  3304, 1674, 447,  1085, 3258, 1844, 1413, 2194, 3045, 928,  2656,
    1851, 1448, 2129, 2476, 3167, 1423, 2212, 2919, 46,   202,  630,  3906, 3292, 1542, 539,  3649, 3029, 816,  2448,
    3307, 1667, 384,  1152, 3977, 3757, 2385, 3756, 2390, 3769, 2365, 4008, 3658, 3044, 935,  2677, 1872, 1209, 3878,
    3552, 434,  1054, 3155, 1451, 2136, 2451, 3298, 1724, 317,  1971, 1552, 633,  3951, 3103, 1103, 3556, 430,  1098,
    3583, 495,  1421, 2218, 2893, 248,  744,  3224, 2010, 1807, 1316, 3061, 976,  2864, 395,  1201, 3870, 3400, 746,
    3222, 2032, 2009, 1798, 1307, 2888, 227,  681,  3423, 655,  3501, 81,   439,  1029, 3090, 1132, 3341, 817,  2455,
    3326, 1768, 145,  1015, 3013, 832,  2240, 2651, 1946, 1743, 100,  316,  1972, 1541, 530,  3710, 2920, 3,    9,
    63,   189,  819,  2457, 3284, 1598, 691,  3353, 861,  2195, 3042, 949,  2571, 1578, 735,  3101, 1089, 3534, 376,
    1640, 785,  2423, 3678, 2952, 675,  3433, 525,  3619, 2811, 1274, 3823, 2207, 3014, 841,  2303, 2790, 1193, 3926,
    3248, 1794, 1287, 2844, 335,  1773, 138,  950,  2562, 1557, 610,  3886, 3544, 282,  1862, 1243, 3592, 2602, 1741,
    106,  278,  1890, 1063, 3324, 1766, 187,  801,  2535, 3502, 88,   392,  1208, 3873, 3573, 473,  1295, 2852, 487,
    1461, 2050, 2069, 2160, 2379, 3818, 2180, 2951, 654,  3498, 68,   476,  1300, 2917, 32,   224,  672,  3424, 562,
    3742, 2504, 3427, 571,  3745, 2421, 3664, 2978, 629,  3915, 3299, 1723, 296,  2008, 1793, 1294, 2851, 498,  1502,
    2323, 3938, 3132, 1190, 3963, 3187, 1355, 2808, 1267, 3792, 2082, 2293, 2768, 1067, 3288, 1562, 591,  4077, 3985,
    3813, 2217, 2884, 199,  597,  4011, 3651, 3035, 794,  2374, 3785, 2157, 2328, 3923, 3243, 1859, 1216, 3657, 3053,
    920,  2760, 1123, 3360, 1010, 3038, 769,  2311, 3854, 3384, 954,  2598, 1769, 150,  994,  2990, 593,  4023, 3607,
    2679, 1886, 1171, 4080, 4034, 3932, 3206, 1920, 1673, 438,  1026, 3079, 1031, 3100, 1094, 3547, 275,  1913, 1126,
    3387, 947,  2585, 1620, 933,  2683, 1914, 1135, 3332, 782,  2346, 4045, 3953, 3141, 1481, 2422, 3673, 2973, 712,
    3192, 1402, 2671, 1814, 1387, 2584, 1619, 944,  2576, 1643, 792,  2376, 3811, 2235, 2874, 445,  1075, 3216, 2018,
    1959, 1660, 893,  2163, 2370, 3797, 2105, 2228, 2839, 382,  1658, 879,  2061, 2104, 2227, 2818, 277,  1899, 1048,
    3137, 1493, 2338, 4085, 4057, 3869, 3393, 725,  3115, 1219, 3648, 3026, 805,  2555, 3578, 500,  1484, 2413, 3608,
    2650, 1949, 1754, 15,   45,   195,  585,  4095, 4079, 3999, 3791, 2175, 2406, 3625, 2765, 1144, 3425, 565,  3723,
    2467, 3186, 1356, 2797, 1176, 4033, 3925, 3257, 1853, 1466, 2095, 2262, 2617, 1716, 261,  1819, 1352, 2801, 1228,
    3693, 2833, 364,  1540, 533,  3691, 2819, 274,  1918, 1139, 3408, 674,  3438, 536,  3656, 3050, 909,  2723, 1394,
    2647, 1982, 1587, 656,  3568, 450,  1358, 2787, 1202, 3863, 3447, 599,  4005, 3689, 2829, 312,  1960, 1617, 958,
    2618, 1725, 314,  1958, 1659, 872,  2072, 2131, 2466, 3189, 1369, 2694, 1417, 2230, 2841, 340,  1708, 333,  1763,
    160,  864,  2080, 2299, 2810, 1277, 3834, 2292, 2775, 1086, 3251, 1803, 1336, 2977, 636,  3956, 3166, 1416, 2225,
    2828, 319,  1981, 1594, 687,  3405, 753,  3287, 1591, 652,  3492, 110,  266,  1846, 1419, 2232, 2867, 386,  1166,
    4003, 3707, 2931, 66,   462,  1386, 2591, 1606, 987,  2817, 284,  1876, 1189, 3954, 3148, 1526, 2507, 3434, 516,
    3612, 2630, 1993, 1910, 1099, 3576, 506,  1510, 2491, 3130, 1204, 3845, 3337, 813,  2499, 3410, 684,  3396, 718,
    3178, 1284, 2837, 368,  1616, 953,  2607, 1750, 43,   209,  567,  3717, 2441, 3236, 1902, 1027, 3072, 1042, 3191,
    1367, 2732, 1375, 2708, 1527, 2508, 3455, 623,  3853, 3377, 901,  2715, 1498, 2319, 3894, 3472, 226,  686,  3402,
    740,  3260, 1830, 1531, 2536, 3459, 155,  961,  2887, 206,  618,  3862, 3440, 578,  4046, 3960, 3194, 1396, 2629,
    1984, 1865, 1270, 3787, 2147, 2354, 3973, 3721, 2477, 3160, 1434, 2255, 2678, 1881, 1158, 3995, 3795, 2091, 2250,
    2669, 1816, 1345, 2766, 1137, 3422, 648,  3512, 58,   166,  882,  2142, 2433, 3228, 1990, 1883, 1160, 4017, 3589,
    2569, 1572, 757,  3275, 1635, 800,  2528, 3515, 51,   153,  975,  2925, 24,   72,   504,  1512, 2449, 3308, 1686,
    491,  1425, 2302, 2785, 1212, 3901, 3489, 117,  331,  1777, 222,  538,  3654, 3008, 859,  2177, 2972, 719,  3181,
    1297, 2942, 97,   295,  2037, 1986, 1863, 1244, 3613, 2625, 2012, 1821, 1370, 2703, 1462, 2059, 2090, 2253, 2680,
    1907, 1104, 3513, 61,   179,  793,  2383, 3830, 2256, 2603, 1738, 127,  381,  1651, 848,  2224, 2827, 298,  2006,
    1835, 1496, 2305, 3868, 3398, 704,  3136, 1490, 2359, 3998, 3784, 2154, 2317, 3896, 3514, 52,   140,  932,  2684,
    1903, 1028, 3093, 1145, 3430, 544,  3808, 2226, 2821, 256,  1792, 1289, 2870, 409,  1231, 3684, 2862, 465,  1335,
    2956, 703,  3389, 929,  2663, 1838, 1475, 2368, 3803, 2067, 2146, 2357, 3984, 3810, 2236, 2863, 470,  1314, 3047,
    942,  2634, 2029, 1930, 1727, 308,  1932, 1709, 330,  1782, 203,  625,  3927, 3255, 1815, 1388, 2573, 1592, 673,
    3431, 551,  3829, 2265, 2580, 1655, 844,  2276, 2727, 1390, 2563, 1554, 631,  3909, 3273, 1645, 778,  2358, 3993,
    3805, 2049, 2076, 2127, 2550, 3545, 285,  1875, 1200, 3865, 3421, 641,  3463, 135,  917,  2795, 1162, 4031, 3631,
    2783, 1030, 3099, 1107, 3504, 2,    14,   42,   214,  546,  3822, 2200, 3027, 802,  2542, 3473, 229,  699,  3361,
    1013, 3019, 874,  2070, 2169, 2420, 3671, 2999, 542,  3674, 2964, 759,  3269, 1609, 1014, 3010, 853,  2219, 2890,
    237,  643,  3465, 173,  835,  2249, 2660, 1831, 1532, 2557, 3560, 394,  1206, 3851, 3363, 1019, 3041, 956,  2612,
    1687, 492,  1412, 2197, 3056, 971,  2929, 76,   484,  1468, 2109, 2216, 2883, 210,  574,  3770, 2356, 3991, 3831,
    2263, 2622, 1697, 366,  1546, 575,  3773, 2337, 4092, 4070, 4000, 3698, 2892, 255,  765,  3315, 1739, 120,  360,
    1560, 577,  4039, 3911, 3271, 1607, 988,  2836, 375,  1605, 978,  2878, 417,  1127, 3388, 934,  2674, 1861, 1234,
    3639, 2711, 1534, 2547, 3522, 348,  1684, 485,  1467, 2088, 2243, 2642, 1957, 1650, 855,  2213, 2912, 59,   161,
    871,  2101, 2192, 3051, 906,  2742, 1305, 2886, 201,  639,  3965, 3169, 1333, 2946, 661,  3563, 387,  1161, 4022,
    3600, 2658, 1845, 1410, 2183, 2958, 689,  3351, 887,  2117, 2496, 3419, 659,  3577, 509,  1523, 2512, 3371, 963,
    2889, 228,  700,  3380, 926,  2778, 1053, 3162, 1428, 2277, 2720, 1403, 2664, 1795, 1280, 2825, 292,  2044, 2045,
    2042, 2031, 1924, 1685, 482,  1454, 2115, 2514, 3365, 1001, 2975, 710,  3154, 1452, 2125, 2552, 3571, 459,  1393,
    2654, 1921, 1678, 419,  1129, 3350, 880,  2128, 2475, 3146, 1508, 2485, 3088, 1122, 3367, 999,  2997, 528,  3696,
    2882, 213,  555,  3793, 2085, 2272, 2747, 1338, 2991, 598,  4002, 3708, 2918, 41,   223,  541,  3667, 2987, 586,
    4086, 4048, 3874, 3580, 486,  1458, 2071, 2174, 2401, 3644, 2726, 1385, 2582, 1657, 870,  2098, 2181, 2944, 667,
    3521, 341,  1707, 344,  1672, 433,  1047, 3180, 1302, 2923, 10,   54,   130,  910,  2730, 1357, 2794, 1165, 4010,
    3652, 3022, 881,  2135, 2494, 3105, 1269, 3778, 2140, 2447, 3254, 1808, 1401, 2662, 1833, 1494, 2347, 4042, 3940,
    3118, 1240, 3585, 2581, 1648, 857,  2191, 2998, 537,  3663, 3071, 998,  2994, 517,  3611, 2643, 1954, 1639, 828,
    2484, 3095, 1143, 3404, 758,  3266, 1628, 925,  2771, 1058, 3303, 1703, 380,  1652, 837,  2267, 2586, 1629, 922,
    2758, 1097, 3574, 464,  1328, 2969, 724,  3116, 1238, 3627, 2755, 1106, 3511, 23,   101,  315,  1953, 1646, 771,
    2313, 3876, 3566, 408,  1224, 3697, 2885, 192,  576,  4032, 3922, 3244, 1878, 1195, 3928, 3226, 2004, 1829, 1522,
    2519, 3390, 936,  2648, 1939, 1776, 217,  527,  3629, 2769, 1068, 3277, 1649, 862,  2202, 3037, 776,  2360, 4019,
    3595, 2595, 1778, 215,  549,  3835, 2291, 2754, 1109, 3490, 124,  372,  1612, 1005, 2947, 658,  3582, 488,  1432,
    2241, 2652, 1935, 1700, 373,  1611, 1016, 3048, 899,  2697, 1444, 2165, 2384, 3755, 2371, 3794, 2092, 2271, 2566,
    1545, 566,  3714, 2460, 3279, 1663, 884,  2124, 2559, 3558, 416,  1120, 3369, 973,  2915, 50,   158,  986,  2822,
    265,  1855, 1460, 2053, 2048, 2075, 2138, 2461, 3272, 1642, 799,  2397, 3720, 2474, 3149, 1521, 2526, 3329, 789,
    2411, 3594, 2596, 1767, 188,  820,  2444, 3263, 1839, 1476, 2389, 3760, 2306, 3861, 3449, 637,  3955, 3147, 1507,
    2464, 3195, 1395, 2640, 1963, 1624, 897,  2695, 1422, 2211, 2930, 69,   475,  1281, 2830, 305,  1943, 1772, 141,
    931,  2665, 1796, 1301, 2914, 53,   139,  945,  2583, 1662, 883,  2137, 2452, 3319, 1751, 44,   196,  604,  3988,
    3838, 2280, 2691, 1426, 2295, 2782, 1025, 3086, 1080, 3233, 1909, 1090, 3527, 327,  1749, 34,   238,  650,  3510,
    16,   112,  336,  1712, 281,  1871, 1252, 3765, 2329, 3924, 3262, 1832, 1489, 2366, 4001, 3701, 2905, 148,  1004,
    2948, 647,  3477, 249,  751,  3213, 1969, 1566, 595,  4025, 3645, 2721, 1404, 2685, 1896, 1041, 3198, 1384, 2577,
    1644, 781,  2339, 4082, 4044, 3958, 3152, 1442, 2151, 2350, 4049, 3877, 3561, 397,  1187, 3936, 3122, 1164, 4013,
    3665, 2981, 608,  3872, 3570, 460,  1380, 2613, 1680, 505,  1519, 2436, 3207, 1927, 1692, 477,  1299, 2928, 75,
    497,  1495, 2348, 4063, 3855, 3391, 943,  2637, 2040, 2017, 1966, 1603, 960,  2880, 219,  513,  3591, 2567, 1550,
    547,  3817, 2189, 3000, 563,  3737, 2525, 3336, 810,  2518, 3385, 957,  2611, 1666, 391,  1173, 4066, 4028, 3622,
    2784, 1211, 3880, 3530, 356,  1596, 701,  3379, 907,  2737, 1292, 2861, 472,  1288, 2865, 396,  1188, 3957, 3161,
    1437, 2266, 2589, 1608, 1009, 3031, 830,  2490, 3133, 1185, 3950, 3096, 1114, 3471, 191,  829,  2483, 3074, 1052,
    3165, 1409, 2190, 2993, 524,  3620, 2798, 1169, 4094, 4072, 3978, 3748, 2414, 3601, 2661, 1824, 1513, 2454, 3321,
    1789, 250,  742,  3250, 1804, 1325, 3018, 877,  2051, 2066, 2149, 2336, 4091, 4083, 4043, 3939, 3131, 1203, 3856,
    3426, 572,  3764, 2334, 3905, 3285, 1593, 678,  3442, 588,  4068, 4014, 3672, 2970, 733,  3091, 1131, 3352, 858,
    2182, 2953, 676,  3452, 614,  3890, 3468, 182,  770,  2318, 3889, 3461, 137,  959,  2621, 1704, 337,  1719, 268,
    1828, 1525, 2498, 3413, 697,  3375, 991,  2845, 328,  1784, 225,  679,  3445, 601,  3983, 3775, 2351, 4054, 3888,
    3458, 156,  980,  2860, 479,  1309, 2906, 157,  979,  2873, 436,  1036, 3117, 1233, 3646, 2728, 1347, 2752, 1115,
    3464, 170,  854,  2210, 2933, 80,   432,  1040, 3193, 1405, 2682, 1917, 1146, 3439, 543,  3677, 2945, 668,  3540,
    318,  1978, 1583, 708,  3164, 1414, 2203, 3034, 797,  2387, 3746, 2428, 3695, 2847, 326,  1746, 55,   133,  923,
    2753, 1116, 3485, 193,  583,  4053, 3897, 3517, 33,   231,  693,  3339, 803,  2537, 3460, 142,  938,  2646, 1977,
    1574, 763,  3297, 1717, 258,  1806, 1315, 3040, 955,  2593, 1788, 253,  755,  3289, 1565, 602,  3974, 3712, 2450,
    3301, 1705, 342,  1698, 359,  1589, 642,  3470, 184,  808,  2520, 3347, 875,  2065, 2156, 2335, 3910, 3264, 1618,
    951,  2565, 1536, 521,  3647, 2735, 1366, 2731, 1354, 2815, 1254, 3771, 2355, 3970, 3740, 2502, 3401, 749,  3203,
    1947, 1736, 113,  343,  1701, 370,  1630, 915,  2809, 1268, 3781, 2121, 2532, 3495, 103,  309,  1931, 1720, 289,
    2023, 1980, 1597, 698,  3366, 992,  2976, 635,  3937, 3125, 1177, 4038, 3904, 3282, 1580, 717,  3171, 1339, 2984,
    579,  4041, 3949, 3089, 1125, 3378, 908,  2724, 1383, 2620, 1711, 324,  1756, 29,   83,   441,  1071, 3268, 1614,
    995,  2985, 580,  4060, 3846, 3328, 786,  2430, 3681, 2869, 400,  1264, 3801, 2077, 2120, 2531, 3506, 12,   36,
    252,  756,  3276, 1654, 843,  2289, 2764, 1151, 3444, 606,  3994, 3796, 2110, 2209, 2940, 111,  269,  1827, 1504,
    2473, 3140, 1486, 2403, 3634, 2700, 1471, 2100, 2199, 3070, 993,  2983, 622,  3850, 3364, 1006, 2954, 685,  3395,
    731,  3073, 1045, 3170, 1340, 3005, 552,  3800, 2074, 2141, 2440, 3235, 1915, 1128, 3345, 869,  2107, 2234, 2877,
    424,  1112, 3457, 149,  1003, 2961, 748,  3204, 1934, 1699, 352,  1568, 745,  3231, 1999, 1892, 1077, 3202, 1948,
    1757, 26,   70,   466,  1342, 2995, 514,  3598, 2616, 1715, 272,  1904, 1113, 3462, 128,  896,  2688, 1435, 2248,
    2659, 1842, 1431, 2284, 2719, 1478, 2395, 3738, 2516, 3383, 919,  2789, 1184, 3945, 3085, 1073, 3230, 1992, 1905,
    1118, 3475, 235,  657,  3575, 471,  1317, 3058, 965,  2907, 154,  966,  2898, 165,  891,  2145, 2364, 4015, 3679,
    2959, 694,  3330, 796,  2388, 3767, 2327, 3966, 3176, 1290, 2879, 422,  1138, 3415, 695,  3333, 777,  2367, 4006,
    3680, 2866, 389,  1179, 4040, 3946, 3076, 1038, 3107, 1275, 3816, 2186, 2989, 600,  3976, 3754, 2372, 3783, 2119,
    2510, 3441, 581,  4059, 3859, 3435, 515,  3593, 2605, 1752};

const uint16_t gf2_12_logTab[4096] = {
    4096, 0,    2912, 2183, 1729, 271,  1000, 1,    546,  2184, 3183, 1706, 3912, 1079, 2913, 2454, 3458, 542,  1001,
    1242, 2000, 2,    523,  3262, 2729, 447,  3991, 272,  1730, 3889, 1271, 1587, 2275, 3770, 3454, 1080, 3913, 1746,
    59,   1977, 817,  3148, 2914, 2630, 3435, 2455, 2079, 1657, 1546, 1707, 3359, 2725, 2808, 3425, 3184, 3759, 547,
    1350, 2706, 3038, 88,   2777, 404,  2185, 1092, 273,  2587, 1956, 2271, 3412, 3992, 865,  2730, 1365, 563,  3533,
    2971, 1126, 794,  448,  3729, 2158, 1965, 3890, 1731, 813,  1447, 1297, 2252, 1847, 1272, 762,  896,  1588, 474,
    1513, 363,  2757, 524,  1858, 2176, 3263, 1542, 3852, 1625, 65,   2242, 3,    2001, 1986, 2576, 3929, 3459, 3840,
    167,  1791, 1523, 2743, 1855, 543,  3000, 1243, 1594, 1236, 3316, 718,  1002, 2785, 4004, 873,  3185, 1885, 1404,
    3760, 773,  2901, 1088, 3679, 2229, 3426, 2809, 3419, 3777, 1920, 1547, 2168, 182,  1928, 3475, 3974, 2350, 1708,
    1788, 2726, 4038, 2666, 3706, 3712, 3360, 831,  2546, 3039, 975,  845,  782,  4041, 2707, 2012, 548,  1940, 3725,
    890,  264,  2948, 114,  1351, 1069, 2017, 664,  2778, 89,   1526, 3674, 74,   3808, 931,  405,  2248, 3386, 2186,
    330,  3605, 3275, 3765, 1574, 2456, 3436, 44,   675,  2321, 993,  3048, 2080, 2860, 359,  1658, 2669, 1500, 442,
    2631, 2977, 1146, 1059, 3136, 2915, 3309, 818,  3293, 803,  3548, 1393, 1621, 2746, 3149, 2276, 3696, 2657, 2153,
    3079, 2923, 608,  3771, 340,  1081, 1560, 4030, 672,  2945, 3455, 1233, 1817, 189,  60,   246,  411,  1978, 53,
    1279, 2133, 3480, 3630, 1747, 3914, 3792, 1602, 2996, 2821, 1084, 3785, 1987, 2002, 2484, 702,  1880, 221,  3363,
    2577, 1568, 3685, 3930, 1718, 22,   4000, 4,    2496, 2372, 1046, 2429, 2243, 2034, 1626, 3462, 2236, 433,  2594,
    2894, 737,  66,   364,  3856, 985,  1784, 3094, 241,  745,  2758, 2292, 1859, 2791, 232,  1167, 884,  525,  1011,
    605,  3416, 1543, 759,  2855, 3853, 1483, 1033, 2523, 1735, 2529, 3264, 2177, 2118, 3743, 2566, 1363, 894,  1856,
    1853, 3887, 544,  3757, 3452, 3694, 409,  2858, 2744, 1524, 2544, 829,  2227, 3460, 3683, 757,  743,  2542, 3174,
    3802, 3841, 3176, 1792, 1765, 1136, 3026, 948,  168,  1760, 3981, 1237, 834,  196,  3576, 1357, 1595, 3804, 3001,
    1606, 343,  1381, 2491, 1636, 2986, 1244, 2625, 1662, 3843, 719,  3317, 3329, 1065, 3010, 2203, 1397, 1003, 322,
    3242, 2786, 2422, 1224, 2092, 763,  2582, 3056, 391,  4068, 1273, 3567, 2253, 989,  2956, 2142, 3587, 3509, 1138,
    1848, 3905, 8,    1865, 1589, 897,  649,  1677, 1507, 3271, 2825, 475,  1767, 1486, 1514, 317,  685,  3354, 3014,
    1448, 3119, 1794, 1298, 4058, 1800, 3971, 1599, 1953, 814,  1732, 754,  2126, 388,  3730, 3178, 2110, 256,  3715,
    16,   2365, 2159, 210,  3891, 438,  1689, 1563, 2409, 1966, 2062, 1093, 1693, 2513, 1904, 1474, 132,  970,  274,
    1896, 1957, 1740, 3114, 3520, 336,  2588, 170,  3252, 2829, 3993, 105,  377,  866,  2847, 4033, 3584, 2257, 1762,
    3413, 2272, 3530, 50,   3709, 634,  1370, 3101, 1127, 2972, 3028, 3158, 2260, 3323, 100,  795,  2736, 2965, 449,
    96,   2129, 950,  3534, 2297, 310,  2447, 1555, 564,  1036, 2731, 3524, 2609, 28,   419,  3073, 1813, 1366, 1638,
    3549, 3996, 4091, 2602, 3224, 804,  1161, 819,  3822, 1301, 1612, 3614, 2211, 697,  3294, 3133, 327,  2180, 1622,
    1394, 2493, 385,  1471, 2502, 3219, 2747, 2085, 535,  3150, 2934, 3738, 2817, 538,  2916, 3553, 1313, 3310, 1189,
    2870, 3958, 348,  1246, 3137, 1060, 691,  851,  1116, 443,  217,  2279, 3557, 1053, 2468, 3345, 2632, 1411, 1147,
    1711, 2283, 3649, 824,  2978, 2988, 3276, 3003, 2673, 3876, 3897, 4087, 601,  3766, 1911, 2457, 3153, 1807, 3657,
    1251, 1575, 2315, 1109, 2353, 676,  3485, 1608, 2322, 3144, 2519, 4079, 3699, 3796, 45,   3437, 1202, 3923, 2025,
    3517, 1797, 2233, 1659, 360,  1703, 3671, 1618, 1672, 108,  2670, 345,  300,  1501, 3945, 2648, 1340, 2861, 552,
    917,  1346, 2288, 2081, 2881, 994,  2121, 935,  3864, 2560, 3397, 1383, 3049, 180,  2899, 3806, 2946, 673,  1144,
    670,  3478, 2704, 1655, 3456, 269,  2574, 1234, 2269, 2156, 2511, 4031, 3321, 3071, 1675, 3054, 1561, 1597, 341,
    1222, 1361, 3172, 3741, 230,  1044, 1082, 2277, 2868, 2500, 2209, 3669, 915,  3655, 3697, 1359, 2154, 1991, 913,
    2619, 3950, 2658, 2569, 1993, 3065, 609,  2191, 582,  3772, 4048, 4061, 1843, 3690, 3860, 2924, 3080, 3578, 577,
    2832, 2798, 150,  54,   836,  3746, 1280, 3108, 497,  2393, 530,  174,  1979, 412,  3872, 2621, 2753, 1818, 591,
    423,  1266, 3255, 2439, 198,  190,  1308, 247,  453,  3952, 1803, 3662, 61,   2199, 1442, 1748, 479,  1102, 2660,
    1207, 3631, 1023, 2134, 3983, 2146, 295,  3977, 3836, 1827, 3481, 1020, 2571, 214,  3793, 3915, 2719, 3234, 2937,
    2059, 374,  1603, 3782, 1239, 2997, 41,   111,  909,  2343, 3675, 3267, 1399, 75,   1873, 640,  3303, 4063, 2885,
    1527, 90,   3497, 2384, 572,  1070, 2205, 3901, 869,  1773, 3381, 959,  2018, 2404, 2779, 2326, 1451, 4050, 3751,
    665,  3373, 2722, 2249, 2920, 3774, 682,  2444, 406,  982,  3809, 906,  3561, 1550, 494,  2616, 324,  932,  2088,
    2164, 1642, 2187, 3387, 460,  584,  354,  303,  122,  331,  1005, 3229, 3606, 3597, 517,  2171, 654,  1831, 2949,
    265,  3244, 1936, 206,  611,  2218, 115,  3918, 2875, 1352, 617,  1287, 2788, 891,  416,  1504, 770,  2942, 3726,
    3035, 549,  3216, 3666, 2750, 943,  2193, 3300, 1941, 2547, 2047, 1995, 1944, 927,  3967, 3168, 3040, 2532, 846,
    2928, 3812, 1182, 3636, 976,  2424, 3122, 3194, 2708, 3430, 3350, 2013, 506,  3067, 380,  396,  1226, 4042, 783,
    2415, 879,  1428, 4005, 3407, 510,  3333, 1330, 2651, 721,  874,  291,  1886, 3044, 3580, 3882, 2505, 3186, 1434,
    713,  1463, 774,  3845, 557,  2902, 1931, 4019, 2337, 1098, 3248, 3761, 1405, 3237, 3082, 1417, 2069, 2834, 1646,
    3420, 2810, 2379, 3017, 2104, 3289, 1892, 3778, 368,  1664, 1921, 2850, 3540, 2401, 3427, 1074, 2376, 579,  2196,
    2230, 3819, 1089, 2627, 2347, 3789, 2962, 3564, 2526, 3680, 3546, 2667, 187,  3077, 1918, 4036, 4039, 1067, 1789,
    1540, 1845, 2969, 1975, 3357, 1077, 2727, 2140, 315,  3012, 3713, 3707, 1738, 1553, 632,  1782, 1481, 3361, 2592,
    3008, 832,  946,  3692, 3862, 3943, 2351, 3895, 1114, 1709, 3222, 3131, 1264, 3106, 372,  3975, 3476, 3319, 3948,
    1841, 1548, 3595, 2341, 1771, 1426, 2926, 2940, 2169, 3331, 1929, 1890, 2960, 630,  185,  183,  1262, 455,  3445,
    2366, 2637, 2813, 2160, 2908, 2368, 1419, 726,  2041, 17,   3716, 1048, 4073, 1696, 3731, 3492, 2639, 1683, 118,
    3954, 429,  3179, 2431, 257,  1028, 1534, 3609, 3084, 2111, 1014, 1950, 1690, 3239, 2031, 997,  1983, 439,  2245,
    211,  1219, 1310, 2312, 3297, 457,  288,  3892, 1319, 4024, 2036, 2410, 1564, 3987, 902,  1407, 3447, 1216, 1967,
    1194, 1751, 2063, 2555, 249,  1634, 2201, 3450, 755,  1733, 1165, 2370, 700,  130,  3250, 2127, 2607, 6,    389,
    1687, 2124, 2775, 815,  3260, 2910, 63,   3314, 1954, 1445, 3972, 4002, 3603, 3723, 3763, 1057, 4028, 1600, 3355,
    1780, 3129, 2339, 1096, 3880, 2374, 3015, 3965, 3120, 1285, 3664, 2162, 680,  1449, 2382, 228,  2702, 4059, 2498,
    528,  1801, 1100, 3232, 2466, 2815, 3736, 1299, 1795, 1344, 1805, 3921, 2093, 482,  1820, 1495, 1490, 1421, 2693,
    764,  2714, 3057, 2904, 1581, 3513, 3190, 2583, 739,  728,  3617, 1274, 2358, 1970, 3568, 624,  593,  2474, 3867,
    68,   4069, 392,  1668, 1132, 559,  4021, 3600, 1170, 3510, 3588, 2596, 2302, 1325, 425,  2221, 1139, 3281, 1961,
    1849, 1336, 2043, 2896, 2143, 2516, 3646, 2613, 1933, 2957, 710,  2254, 2107, 19,   3573, 2740, 1268, 842,  990,
    2334, 1768, 614,  2441, 1050, 2022, 476,  1652, 3272, 887,  520,  715,  2488, 1877, 435,  2826, 489,  3718, 3020,
    1515, 1487, 464,  3257, 1213, 3212, 1907, 318,  2238, 2762, 686,  1465, 284,  157,  776,  1678, 922,  3464, 1508,
    3829, 1173, 163,  192,  1105, 650,  898,  1835, 1698, 467,  3906, 1628, 938,  2307, 3847, 3198, 2681, 9,    1377,
    1590, 2214, 4075, 200,  2551, 1866, 1197, 3092, 3414, 1716, 431,  2623, 1355, 1763, 2225, 3585, 2823, 4056, 254,
    3582, 334,  2295, 2258, 1521, 2755, 472,  3531, 2273, 3423, 3181, 1585, 1391, 3046, 51,   2151, 1086, 3710, 973,
    72,   1328, 1461, 2848, 3787, 2138, 4034, 1888, 1839, 492,  120,  1871, 867,  378,  3634, 414,  204,  3253, 148,
    39,   293,  178,  3052, 1989, 2830, 2558, 106,  3142, 3874, 3956, 822,  3994, 1469, 1094, 2700, 1685, 3721, 1317,
    1981, 1026, 1694, 2486, 1905, 3827, 2305, 2472, 3188, 2514, 1323, 176,  1459, 971,  252,  808,  275,  3825, 2641,
    1436, 2537, 2767, 133,  1475, 2004, 1386, 2643, 810,  401,  1882, 337,  3521, 1862, 1008, 3884, 3494, 3165, 2589,
    2398, 2865, 171,  2878, 532,  660,  3115, 2507, 3403, 2677, 277,  1741, 704,  1897, 3204, 2395, 3089, 3489, 3733,
    1649, 1958, 1615, 3611, 3062, 450,  2966, 2066, 3748, 503,  2563, 2539, 97,   2579, 1925, 2130, 3409, 2076, 1210,
    2737, 3442, 1282, 3086, 1518, 796,  4011, 3324, 1155, 2689, 4007, 1438, 3591, 1570, 101,  635,  223,  3503, 135,
    3335, 32,   83,   1371, 2072, 1128, 1256, 2113, 3110, 799,  3102, 2055, 125,  512,  3159, 235,  3365, 2261, 2769,
    1724, 620,  499,  2479, 3029, 2973, 1900, 1016, 3939, 259,  141,  565,  2837, 3391, 1037, 4014, 152,  1477, 2389,
    24,   1556, 2448, 749,  3935, 1332, 951,  3470, 2800, 1290, 963,  2433, 3207, 3535, 2794, 311,  2653, 306,  644,
    2006, 2298, 1720, 3932, 29,   1388, 3400, 3126, 723,  2610, 281,  2732, 3626, 1536, 1304, 2051, 838,  1754, 3525,
    876,  3378, 3286, 3074, 420,  3687, 2599, 2645, 56,   1123, 1814, 2663, 2953, 1367, 3023, 1030, 3821, 696,  1160,
    1637, 2492, 2179, 2084, 534,  216,  3344, 2987, 1410, 690,  1245, 3552, 1312, 2120, 1382, 2880, 1339, 1702, 2232,
    344,  299,  3002, 600,  2314, 1910, 1201, 3795, 3484, 1607, 3982, 1826, 1022, 1441, 2718, 213,  3781, 1238, 590,
    197,  2198, 1307, 3871, 173,  835,  3745, 1221, 1043, 1596, 2510, 1143, 3805, 268,  2573, 2867, 3654, 2568, 1358,
    3577, 3859, 2190, 581,  1539, 1076, 1066, 3545, 1737, 3011, 2591, 3007, 3594, 2939, 1261, 3330, 3318, 371,  3894,
    1113, 2626, 2525, 3818, 2400, 2378, 1645, 367,  1663, 3406, 720,  1433, 290,  3236, 3247, 3844, 556,  905,  323,
    981,  2721, 459,  1641, 1004, 3228, 2204, 958,  3372, 2403, 3496, 2884, 3266, 1398, 3215, 3299, 3034, 2787, 3243,
    1830, 3917, 2874, 2046, 3167, 2423, 2531, 2414, 1225, 3429, 3349, 988,  1137, 3566, 2091, 648,  1864, 1766, 1485,
    3177, 2364, 2061, 209,  753,  1952, 3118, 1793, 3523, 1812, 1035, 949,  3027, 3100, 2735, 2964, 1692, 969,  169,
    1895, 3529, 1761, 104,  376,  1605, 2985, 3803, 3980, 3328, 3842, 321,  3241, 3682, 3801, 1759, 3175, 2543, 2857,
    1852, 3886, 3461, 736,  2033, 3999, 2483, 3784, 1567, 3684, 3855, 744,  1010, 2291, 2117, 2528, 758,  2854, 1364,
    793,  864,  1091, 812,  1964, 761,  895,  3839, 1854, 2784, 2999, 1985, 2241, 1857, 2175, 1349, 403,  3758, 1545,
    1745, 3453, 2629, 3434, 4094, 999,  2453, 545,  3888, 3990, 1241, 1999, 1939, 113,  2011, 2545, 1525, 663,  2247,
    3385, 2167, 2349, 830,  1787, 3418, 2228, 1884, 1403, 3292, 2745, 3308, 441,  43,   1573, 2859, 358,  3695, 607,
    1232, 339,  3791, 3629, 245,  410,  2822, 2294, 2224, 3091, 3422, 471,  2150, 1085, 147,  1988, 1468, 2557, 3633,
    1870, 3786, 2137, 3203, 1648, 703,  659,  1861, 1881, 2397, 2864, 2699, 1025, 1322, 2485, 2003, 2766, 251,  807,
    3625, 1753, 280,  3931, 3686, 3285, 2662, 2952, 3469, 3206, 1719, 2793, 748,  23,   2836, 3390, 1154, 1569, 4010,
    1209, 2065, 3061, 2578, 1924, 222,  82,   2054, 2071, 1899, 2478, 234,  3364, 886,  434,  1651, 2333, 463,  3019,
    2237, 2761, 1627, 2680, 1196, 1376, 1834, 1104, 921,  3463, 2106, 841,  709,  2895, 2595, 1169, 3280, 1960, 481,
    2692, 738,  2713, 1667, 67,   2357, 1969, 1218, 287,  2244, 1949, 3986, 2035, 1193, 1750, 3491, 428,  1013, 2430,
    1047, 2040, 2636, 2812, 4001, 4027, 1444, 2774, 1164, 3449, 2606, 5,    1779, 2373, 2381, 3964, 1343, 3735, 2497,
    527,  2363, 3117, 1484, 987,  3099, 1034, 1894, 3528, 735,  1566, 2853, 3854, 2856, 1758, 3979, 3327, 606,  244,
    357,  3291, 662,  2010, 1786, 3417, 792,  760,  2174, 3838, 3989, 2452, 1544, 1744, 957,  3265, 3227, 904,  1829,
    3033, 2530, 2413, 2524, 366,  555,  3405, 370,  1260, 3544, 1736, 599,  3483, 298,  2119, 2178, 1159, 1409, 689,
    1825, 3780, 3744, 589,  3858, 2567, 2509, 1142, 2679, 920,  2760, 885,  1168, 708,  2712, 1666, 4026, 2605, 526,
    1778, 2039, 1012, 1948, 3985, 81,   233,  1923, 1153, 3284, 279,  2792, 747,  2293, 2149, 2136, 146,  2765, 1321,
    658,  1860, 365,  3543, 2412, 956,  1158, 297,  588,  3857, 243,  1785, 1743, 791,  1757, 2852, 986,  3098, 2148,
    657,  746,  80,   707,  2759, 1777, 2038, 3542, 587,  3097, 242,  3095, 3096, 79,   706,  3367, 2889, 2262, 3637,
    1183, 3366, 1454, 1184, 1630, 1455, 977,  2770, 1725, 2425, 1185, 350,  236,  3813, 3638, 2840, 858,  2263, 2929,
    3160, 2533, 126,  3960, 3368, 2890, 3908, 513,  847,  2548, 621,  2309, 1631, 1456, 3139, 500,  2048, 3030, 1945,
    2771, 2696, 3341, 978,  1996, 2480, 1248, 1186, 3169, 1017, 3940, 3041, 351,  940,  2426, 2419, 1901, 3968, 928,
    2974, 3926, 1726, 767,  514,  507,  3103, 2056, 3068, 848,  4084, 3909, 3849, 800,  2014, 3351, 3111, 1062, 2891,
    3123, 2073, 36,   2534, 127,  2028, 1129, 3195, 2114, 3431, 3369, 693,  3200, 3961, 2709, 1257, 136,  4043, 2841,
    2683, 853,  3639, 1227, 3504, 381,  636,  2804, 237,  3814, 2329, 224,  397,  2264, 1118, 33,   2416, 784,  3336,
    11,   859,  568,  2930, 880,  84,   1372, 1429, 3161, 2462, 451,  2751, 1018, 1205, 2267, 3170, 3667, 3063, 550,
    1616, 4077, 1249, 1187, 3555, 3612, 3217, 3042, 1415, 2067, 2194, 944,  2967, 1424, 3941, 2918, 352,  3301, 3749,
    504,  1942, 941,  2216, 1592, 3927, 3727, 3410, 2077, 3036, 1727, 540,  2975, 2319, 2131, 2943, 771,  1926, 262,
    929,  2789, 2564, 2819, 2427, 2420, 1379, 2540, 892,  2580, 1505, 3969, 2407, 2845, 1902, 417,  98,   2172, 3325,
    597,  3031, 1946, 144,  1156, 655,  4008, 2950, 2697, 1868, 1191, 2772, 1832, 2690, 2782, 1997, 1937, 1571, 102,
    207,  2481, 2983, 979,  2872, 3592, 3245, 266,  1439, 1199, 3342, 3140, 202,  1519, 1353, 2876, 3087, 1315, 1457,
    3440, 501,  618,  797,  4012, 1288, 2049, 1121, 1283, 3919, 1632, 3312, 2553, 2310, 116,  3443, 612,  1211, 161,
    2549, 622,  1493, 2738, 2219, 910,  2795, 3394, 382,  637,  1179, 312,  2344, 307,  3268, 238,  826,  1510, 2805,
    3676, 2654, 1531, 225,  1874, 2299, 1721, 641,  398,  4053, 2330, 3466, 2007, 76,   1400, 645,  3651, 3815, 3640,
    2990, 2434, 3498, 91,   964,  1175, 854,  787,  1228, 2385, 3208, 3536, 573,  3505, 3702, 1291, 1528, 2684, 3831,
    2980, 2842, 2886, 2801, 3304, 952,  485,  137,  4044, 2100, 3471, 4064, 2838, 1452, 2417, 3339, 4082, 34,   2327,
    566,  2405, 260,  1413, 2265, 1119, 159,  142,  2780, 3337, 2096, 1038, 3752, 4051, 3392, 2098, 785,  778,  12,
    666,  4015, 153,  3374, 860,  1149, 1713, 3162, 960,  3936, 1333, 2019, 2463, 1680, 1430, 1040, 750,  3382, 1774,
    2449, 3622, 1373, 1071, 1478, 924,  569,  2931, 2285, 2390, 2206, 1557, 870,  85,   1294, 3754, 881,  3902, 25,
    1151, 2710, 585,  1755, 3526, 355,  1258, 1823, 3962, 2634, 839,  461,  3388, 2052, 469,  3201, 2089, 2733, 3799,
    2115, 3432, 862,  3627, 2165, 1305, 2188, 694,  1700, 3347, 3370, 1643, 1537, 3401, 1006, 2535, 2470, 1837, 37,
    332,  1389, 304,  3933, 3376, 3124, 2074, 2687, 30,   123,  2029, 900,  724,  3607, 3230, 3127, 1055, 128,  1579,
    1130, 3598, 2611, 282,  518,  3196, 155,  3069, 668,  3688, 2617, 495,  421,  3834, 2057, 2281, 849,  325,  2600,
    2646, 933,  4085, 1107, 3075, 1551, 3104, 628,  4017, 508,  3562, 3287, 3810, 877,  652,  768,  515,  3559, 3379,
    907,  2723, 57,   445,  3910, 3850, 165,  1124, 2250, 2664, 3775, 2015, 780,  1498, 801,  2921, 1815, 194,  1063,
    407,  3024, 1031, 983,  2892, 219,  3112, 48,   1368, 2445, 683,  2954, 14,   3352, 1909, 1200, 2231, 2879, 533,
    3820, 3343, 3551, 1440, 2717, 172,  2197, 580,  2866, 1042, 267,  2402, 3495, 1640, 980,  2873, 3214, 3166, 3428,
    2399, 2377, 3246, 1432, 1112, 3593, 1075, 2590, 338,  3790, 1572, 3307, 3384, 1938, 2348, 1883, 1090, 811,  2240,
    2783, 1998, 4093, 402,  2628, 208,  752,  1863, 3565, 2963, 3522, 968,  103,  3998, 2482, 2527, 1009, 3885, 3681,
    2984, 320,  145,  2764, 278,  1922, 1665, 2678, 2604, 1947, 955,  1157, 2851, 1742, 705,  3541, 656,  1776, 3404,
    369,  3032, 3226, 688,  598,  3779, 2508, 3290, 661,  2451, 2173, 3326, 734,  3116, 1893, 2070, 1898, 3060, 4009,
    2951, 3624, 3205, 2835, 3090, 3421, 1869, 1467, 806,  2698, 1647, 2396, 1375, 1833, 3018, 1650, 1959, 2105, 2691,
    2356, 2773, 1163, 3734, 2380, 2811, 3490, 286,  1192, 4006, 1437, 1517, 3441, 502,  1614, 2538, 3408, 134,  3334,
    798,  1255, 3938, 619,  511,  2768, 1303, 2050, 722,  1387, 2644, 875,  1122, 3022, 1289, 962,  2005, 2652, 1331,
    1476, 140,  4013, 3088, 3488, 276,  2506, 3883, 809,  3164, 2877, 3720, 1316, 3187, 3826, 2642, 1435, 1458, 3824,
    253,  3581, 1354, 1715, 1584, 1520, 3045, 972,  292,  177,  821,  3141, 203,  491,  1460, 1887, 3722, 3762, 3313,
    3259, 699,  1633, 3249, 1686, 2338, 1095, 679,  1284, 3920, 2465, 2701, 1099, 2311, 3296, 1982, 3238, 1406, 1318,
    1215, 2554, 1682, 117,  3083, 1027, 1695, 1418, 3444, 2907, 3572, 2739, 1932, 2515, 1324, 4020, 2220, 1335, 1494,
    1489, 3189, 2903, 558,  2473, 3616, 623,  714,  2487, 2021, 613,  1212, 488,  1906, 1464, 2306, 3846, 2550, 2213,
    466,  162,  775,  3828, 432,  2593, 2428, 2495, 1879, 2820, 3362, 1717, 1783, 3093, 883,  2790, 2565, 2522, 3415,
    1482, 1380, 2490, 1356, 833,  3009, 2624, 1396, 2421, 742,  2541, 947,  1764, 2226, 3693, 893,  3756, 27,   418,
    1554, 2296, 2259, 633,  99,   95,   1903, 1473, 335,  1739, 3708, 3583, 2828, 2846, 2141, 3586, 4067, 2581, 1506,
    3904, 2824, 316,  255,  3714, 2408, 437,  387,  3970, 3013, 4057, 3547, 1392, 3135, 2976, 2320, 3274, 3047, 2668,
    2152, 3078, 2944, 1559, 2995, 2132, 188,  52,   889,  263,  4040, 974,  73,   1068, 930,  329,  1927, 3474, 3711,
    4037, 1919, 1087, 872,  772,  3037, 87,   3424, 3358, 1976, 2274, 3147, 2078, 2182, 1728, 1078, 3182, 1586, 2728,
    541,  522,  3532, 2970, 3411, 2586, 1296, 3728, 1846, 473,  1790, 1522, 717,  1593, 3928, 1624, 2756, 1541, 3171,
    3740, 3053, 3320, 3477, 179,  1654, 2268, 2208, 3668, 3949, 1990, 2831, 1842, 3064, 4047, 294,  3976, 1206, 478,
    2936, 1019, 373,  40,   1265, 3254, 3661, 452,  2752, 2392, 149,  3107, 3863, 2559, 2287, 551,  1617, 3516, 107,
    3944, 3875, 3896, 1250, 3152, 2024, 4078, 2352, 3143, 1611, 3613, 3223, 3995, 1470, 3132, 3218, 2933, 3556, 1052,
    823,  1710, 1115, 3957, 537,  1188, 2749, 942,  2941, 415,  205,  2170, 2217, 616,  1943, 926,  3635, 2927, 1427,
    379,  3193, 505,  1549, 493,  2443, 2919, 353,  2087, 121,  3596, 868,  1772, 3750, 2325, 571,  3302, 2342, 1872,
    3788, 2961, 2195, 1073, 2103, 2068, 1891, 2849, 3332, 1329, 2504, 3043, 1416, 2336, 1462, 1930, 2968, 1974, 4035,
    186,  631,  2139, 1480, 945,  1770, 1425, 184,  1889, 1840, 1263, 3942, 3221, 2638, 3953, 3608, 1533, 4072, 725,
    454,  2367, 1309, 456,  996,  2030, 901,  4023, 3446, 248,  3128, 3879, 2161, 3663, 1804, 2814, 227,  3231, 3602,
    1056, 62,   2909, 2369, 2200, 129,  2123, 937,  3197, 199,  4074, 1697, 191,  156,  1172, 519,  1876, 1049, 2440,
    3256, 3717, 3211, 283,  1819, 1420, 3512, 1580, 1131, 3866, 727,  592,  18,   1267, 2612, 3645, 2301, 3599, 424,
    2042, 2799, 2432, 643,  305,  3934, 2388, 258,  151,  1535, 837,  3125, 3399, 2598, 3377, 55,   1029, 3502, 31,
    3109, 2112, 1015, 498,  124,  1723, 2688, 3590, 3085, 1281, 3747, 3610, 2562, 2075, 38,   3051, 3955, 3873, 413,
    119,  1327, 1838, 4055, 333,  2622, 430,  3180, 2754, 1390, 71,   1684, 1980, 2471, 2304, 1385, 2536, 175,  2640,
    2394, 3732, 2676, 3402, 1007, 400,  3493, 531,  356,  2009, 3988, 3837, 3978, 1565, 2362, 3527, 554,  1259, 1828,
    903,  1408, 3482, 1824, 1141, 2411, 296,  1756, 790,  78,   586,  2147, 2037, 2135, 1320, 3283, 1152, 2711, 919,
    4025, 3984, 1443, 3448, 1342, 3963, 2635, 427,  1217, 1749, 1195, 1103, 462,  2332, 3279, 840,  480,  1968, 2223,
    470,  3632, 2556, 250,  1024, 3202, 2863, 2053, 2477, 2064, 1208, 2661, 1752, 3468, 3389, 3817, 1644, 3235, 289,
    3893, 2938, 1538, 3006, 3371, 2883, 458,  2720, 3916, 3298, 2045, 3348, 1021, 212,  3870, 1306, 2189, 3653, 1220,
    2572, 2313, 3794, 1701, 1338, 2083, 695,  215,  1311, 2032, 3783, 2116, 2290, 1851, 3800, 1604, 3240, 2060, 1951,
    647,  2090, 2734, 1811, 1691, 375,  863,  1963, 1984, 2998, 1240, 998,  1348, 3433, 1231, 3628, 42,   440,  2246,
    112,  2166, 1402, 3900, 3380, 4049, 1450, 2383, 4062, 908,  639,  3560, 2615, 681,  3773, 583,  2163, 302,  516,
    1994, 3966, 1181, 3811, 878,  395,  3121, 3066, 3665, 2192, 769,  1503, 1935, 653,  610,  1286, 2340, 2925, 629,
    2959, 3947, 3105, 3861, 3130, 1844, 3356, 1917, 3076, 1552, 314,  1781, 3691, 509,  2650, 3881, 3579, 3081, 1097,
    712,  4018, 2346, 3563, 578,  2375, 3016, 2833, 3288, 3539, 422,  2438, 1802, 3951, 2620, 529,  2797, 496,  2145,
    3835, 2659, 1101, 3233, 2570, 2058, 110,  2499, 914,  2618, 912,  576,  3689, 1992, 4060, 1360, 229,  1674, 3070,
    669,  2898, 2703, 2155, 2278, 2467, 3648, 2282, 850,  347,  2816, 2869, 1300, 2210, 2601, 4090, 384,  326,  2501,
    3737, 2672, 4086, 3656, 1806, 3922, 3698, 1108, 2518, 934,  3396, 1345, 916,  3670, 1796, 1671, 2647, 181,  3973,
    3705, 2665, 3776, 3678, 4003, 2900, 3724, 2947, 781,  844,  3673, 2016, 3807, 3604, 2656, 2922, 671,  4029, 1601,
    3479, 1816, 1278, 802,  1620, 1058, 1145, 674,  3764, 992,  1499, 166,  2742, 3315, 1235, 2575, 64,   362,  3851,
    562,  1125, 2270, 1955, 1446, 2157, 2251, 1512, 2911, 270,  3911, 1705, 1270, 446,  3457, 3261, 2705, 2776, 2807,
    2724, 58,   3769, 816,  1656, 756,  3173, 3025, 1135, 828,  408,  1362, 3451, 342,  1635, 3575, 195,  1064, 1661,
    2202, 1223, 984,  240,  1166, 231,  3742, 1734, 604,  1032, 2235, 2893, 1045, 2371, 701,  1083, 220,  21,   2109,
    15,   1562, 1688, 2125, 1598, 3353, 1799, 2955, 3508, 390,  3055, 1676, 7,    3270, 684,  2512, 131,  3519, 3113,
    49,   2256, 3251, 4032, 2608, 3072, 2446, 309,  3157, 1369, 3322, 2128, 1639, 3213, 1111, 1431, 1041, 2716, 1908,
    3550, 2239, 4092, 3383, 3306, 967,  751,  3997, 319,  3059, 3623, 805,  1466, 285,  1162, 1374, 2355, 2450, 733,
    687,  3225, 2603, 2763, 954,  1775, 2020, 487,  465,  2212, 3615, 1488, 3571, 1334, 678,  2464, 698,  3258, 1214,
    3295, 1681, 2906, 1516, 1613, 3937, 1254, 139,  961,  1302, 3021, 820,  490,  1583, 1714, 3163, 3487, 3719, 3823,
    2442, 2086, 570,  2324, 3192, 925,  2748, 615,  2503, 2335, 2102, 1072, 1479, 1973, 1769, 3220, 2286, 3515, 2023,
    3151, 536,  1051, 1610, 2932, 3660, 2391, 2935, 477,  1653, 3739, 2207, 4046, 4066, 3903, 386,  436,  2827, 1472,
    26,   94,   882,  2521, 1878, 2494, 1395, 2489, 741,  3755, 3134, 3273, 2994, 1558, 871,  3473, 888,  328,  716,
    1623, 1295, 2585, 3146, 86,   2181, 521,  3798, 861,  3346, 1699, 468,  2633, 1150, 1822, 3375, 2686, 1836, 2469,
    1054, 899,  1578, 154,  444,  164,  1497, 779,  13,   47,   193,  218,  651,  3558, 4016, 627,  3833, 667,  2280,
    1106, 923,  2284, 3753, 1293, 3621, 1039, 1712, 1679, 1412, 158,  4081, 3338, 2097, 2095, 777,  1148, 3393, 1178,
    1509, 825,  3650, 3465, 1530, 4052, 484,  2099, 2979, 3830, 1174, 2989, 786,  3701, 35,   2027, 3199, 692,  1061,
    3848, 766,  4083, 2803, 2328, 852,  2682, 10,   1117, 567,  2461, 2308, 3138, 3340, 2695, 3925, 2418, 1247, 939,
    3959, 3907, 857,  2839, 1453, 2888, 1629, 349,  2818, 1378, 2844, 2406, 261,  2318, 1591, 539,  4076, 3554, 2266,
    1204, 1423, 1414, 2917, 2215, 596,  143,  1190, 1867, 1198, 2871, 2781, 2982, 160,  1492, 2552, 3311, 1314, 201,
    3439, 1120, 1180, 394,  1934, 1502, 301,  2614, 3899, 638,  1916, 313,  3946, 2958, 711,  2649, 2345, 3538, 3647,
    346,  383,  4089, 1670, 3395, 2671, 2517, 1673, 2897, 575,  911,  2796, 2437, 2144, 109,  3518, 2255, 3156, 308,
    3269, 3507, 2108, 1798, 3574, 1660, 827,  1134, 603,  239,  2234, 20,   3704, 3677, 3672, 843,  991,  1619, 2655,
    1277, 2806, 3768, 1269, 1704, 361,  2741, 561,  1511, 3869, 3652, 2082, 1337, 2044, 2882, 3816, 3005, 646,  1810,
    1850, 2289, 1347, 1962, 1230, 1401, 1341, 426,  3278, 2331, 3467, 2476, 2222, 2862, 3282, 918,  77,   789,  2361,
    2008, 553,  1140, 3511, 3865, 2300, 3644, 3210, 1875, 936,  1171, 995,  4022, 4071, 1532, 226,  3878, 3601, 2122,
    642,  2387, 2597, 3398, 2561, 3589, 3501, 1722, 2675, 399,  1384, 2303, 1326, 3050, 4054, 70,   1496, 46,   3832,
    626,  1577, 2685, 3797, 1821, 4080, 2094, 3620, 1292, 1529, 1177, 483,  3700, 2843, 2317, 1422, 1203, 3438, 1491,
    595,  2981, 856,  2887, 3924, 2694, 765,  2026, 2802, 2460, 2993, 3472, 3145, 2584, 740,  2520, 4065, 93,   2101,
    1972, 3191, 2323, 1609, 3514, 3659, 4045, 1110, 2715, 966,  3305, 953,  732,  3058, 2354, 1582, 3486, 138,  1253,
    3570, 486,  677,  2905, 3277, 2475, 2360, 788,  1229, 1809, 3868, 3004, 4070, 3877, 3209, 3643, 3500, 2386, 2674,
    69,   3155, 3506, 602,  1133, 560,  3767, 3703, 1276, 574,  2436, 1669, 4088, 3898, 393,  1915, 3537, 965,  731,
    3569, 1252, 3658, 1971, 2992, 92,   3619, 1176, 1576, 625,  594,  2316, 855,  2459, 2359, 1808, 3499, 3642, 1914,
    2435, 3154, 1275, 1912, 729,  1913, 3641, 2991, 730,  3618, 2458};
